/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LoggingUtils;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.security.ssl.SslClientCertificateImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslClientCertificateHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(SslClientCertificateHandler.class);
    @NotNull
    private final Tls tls;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    public SslClientCertificateHandler(@NotNull Tls tls, @NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.tls = tls;
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) throws Exception {
        if (!(evt instanceof SslHandshakeCompletionEvent)) {
            super.userEventTriggered(ctx, evt);
            return;
        }
        SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)evt;
        if (!sslHandshakeCompletionEvent.isSuccess()) {
            log.trace("Handshake failed", sslHandshakeCompletionEvent.cause());
            return;
        }
        Channel channel = ctx.channel();
        try {
            SslHandler sslHandler = (SslHandler)channel.pipeline().get("ssl_handler");
            SSLSession session = sslHandler.engine().getSession();
            Certificate[] peerCertificates = session.getPeerCertificates();
            SslClientCertificateImpl sslClientCertificate = new SslClientCertificateImpl(peerCertificates);
            ClientConnectionContext.of(channel).setAuthCertificate(sslClientCertificate);
        }
        catch (SSLPeerUnverifiedException e) {
            this.handleSslPeerUnverifiedException(channel, e);
        }
        catch (ClassCastException e2) {
            String eventLogMessage = LoggingUtils.appendListenerToMessage(channel, "SSL handshake failed");
            this.mqttServerDisconnector.logAndClose(channel, null, eventLogMessage);
            throw new RuntimeException("Not able to get SslHandler from pipeline", e2);
        }
        channel.pipeline().remove((ChannelHandler)this);
    }

    private void handleSslPeerUnverifiedException(@NotNull Channel channel, SSLPeerUnverifiedException e) {
        if ("peer not authenticated".equals(e.getMessage()) || "peer not verified".equals(e.getMessage())) {
            if (Tls.ClientAuthMode.REQUIRED.equals((Object)this.tls.getClientAuthMode())) {
                log.error("Client certificate authentication forced but no client certificate was provided. Disconnecting.", (Throwable)e);
                String eventLogMessage = LoggingUtils.appendListenerToMessage(channel, "No client certificate provided");
                this.mqttServerDisconnector.logAndClose(channel, null, eventLogMessage);
            } else if (Tls.ClientAuthMode.OPTIONAL.equals((Object)this.tls.getClientAuthMode())) {
                log.debug("Client did not provide SSL certificate for authentication. Could not authenticate at application level");
            }
        } else {
            log.error("An error occurred. Disconnecting client.", (Throwable)e);
            String eventLogMessage = LoggingUtils.appendListenerToMessage(channel, "SSL handshake failed");
            this.mqttServerDisconnector.logAndClose(channel, null, eventLogMessage);
        }
    }
}

