/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.security.exception.SslException;
import com.hivemq.security.ssl.SslUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;

@LazySingleton
public class SslContextFactory {
    @NotNull
    public SslContext createSslContext(@NotNull Tls tls) {
        try {
            List<String> cipherSuites;
            SslContextBuilder builder = SslContextBuilder.forServer((KeyManagerFactory)SslUtil.getKeyManagerFactory(tls)).sslProvider(SslProvider.JDK).trustManager(SslUtil.getTrustManagerFactory(tls)).clientAuth(SslContextFactory.toClientAuth(tls.getClientAuthMode()));
            if (!tls.getProtocols().isEmpty()) {
                builder.protocols(tls.getProtocols());
            }
            if ((cipherSuites = tls.getCipherSuites()) != null && !cipherSuites.isEmpty()) {
                builder.ciphers(cipherSuites, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
            } else {
                builder.ciphers(null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
            }
            return builder.build();
        }
        catch (SSLException e) {
            throw new SslException("Not able to create SSL server context", e);
        }
    }

    @NotNull
    private static ClientAuth toClientAuth(@NotNull Tls.ClientAuthMode clientAuthMode) {
        switch (clientAuthMode) {
            case NONE: {
                return ClientAuth.NONE;
            }
            case OPTIONAL: {
                return ClientAuth.OPTIONAL;
            }
            case REQUIRED: {
                return ClientAuth.REQUIRE;
            }
        }
        throw new SslException("Invalid auth mode: " + String.valueOf((Object)clientAuthMode));
    }
}

