/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.security.exception.SslException;
import com.hivemq.security.ssl.SslContextStore;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class SslFactory {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);
    @NotNull
    private final SslContextStore sslContextStore;

    @Inject
    public SslFactory(@NotNull SslContextStore sslContextStore) {
        this.sslContextStore = sslContextStore;
    }

    @NotNull
    public SslHandler getSslHandler(@NotNull Channel ch, @NotNull Tls tls, @NotNull SslContext sslContext) throws SslException {
        SSLEngine sslEngine = sslContext.newEngine(ch.alloc());
        Boolean preferServerCipherSuites = tls.isPreferServerCipherSuites();
        if (preferServerCipherSuites != null) {
            SSLParameters params = sslEngine.getSSLParameters();
            params.setUseCipherSuitesOrder(preferServerCipherSuites);
            sslEngine.setSSLParameters(params);
        }
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis((long)tls.getHandshakeTimeout());
        return sslHandler;
    }

    @NotNull
    public SslContext getSslContext(@NotNull Tls tls) throws SslException {
        return this.sslContextStore.getAndInitAsync(tls);
    }

    public void verifySslAtBootstrap(@NotNull Listener listener, @NotNull Tls tls) {
        try {
            this.sslContextStore.createAndInitIfAbsent(tls, sslContext -> {
                SSLEngine sslEngine = sslContext.newEngine((ByteBufAllocator)new PooledByteBufAllocator());
                log.info("Enabled protocols for {} at address {} and port {}: {}", new Object[]{listener.readableName(), listener.getBindAddress(), listener.getPort(), Arrays.toString(sslEngine.getEnabledProtocols())});
                Object[] enabledCipherSuites = sslEngine.getEnabledCipherSuites();
                log.info("Enabled cipher suites for {} at address {} and port {}: {}", new Object[]{listener.readableName(), listener.getBindAddress(), listener.getPort(), Arrays.toString(enabledCipherSuites)});
                List<String> cipherSuites = tls.getCipherSuites();
                if (!cipherSuites.isEmpty()) {
                    Object unknownCipherSuitesSet;
                    if (sslContext instanceof OpenSslServerContext) {
                        HashSet<String> enabledCipherSuitesSet = new HashSet<String>();
                        for (Object enabledCipherSuite : enabledCipherSuites) {
                            enabledCipherSuitesSet.add(((String)enabledCipherSuite).substring(4));
                        }
                        unknownCipherSuitesSet = new HashSet();
                        for (String cipherSuite : cipherSuites) {
                            if (cipherSuite == null || enabledCipherSuitesSet.contains(cipherSuite.substring(4))) continue;
                            unknownCipherSuitesSet.add(cipherSuite);
                        }
                    } else {
                        unknownCipherSuitesSet = Sets.difference((Set)ImmutableSet.copyOf(cipherSuites), (Set)ImmutableSet.copyOf((Object[])enabledCipherSuites));
                    }
                    if (!unknownCipherSuitesSet.isEmpty()) {
                        log.warn("Unknown cipher suites for {} at address {} and port {}: {}", new Object[]{listener.readableName(), listener.getBindAddress(), listener.getPort(), unknownCipherSuitesSet});
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Not able to create SSL server context. Reason: {}", (Object)e.getMessage());
            log.debug("Original exception", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }
}

