/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.hivemq.bootstrap.ClientConnectionContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import javax.inject.Singleton;
import javax.net.ssl.SSLSession;

@ChannelHandler.Sharable
@Singleton
public class SslParameterHandler
extends ChannelInboundHandlerAdapter {
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt instanceof SslHandshakeCompletionEvent)) {
            super.userEventTriggered(ctx, evt);
            return;
        }
        Channel channel = ctx.channel();
        SslHandler sslHandler = (SslHandler)channel.pipeline().get("ssl_handler");
        SSLSession session = sslHandler.engine().getSession();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        clientConnectionContext.setAuthCipherSuite(session.getCipherSuite());
        clientConnectionContext.setAuthProtocol(session.getProtocol());
        channel.pipeline().remove((ChannelHandler)this);
        super.userEventTriggered(ctx, evt);
    }
}

