/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.statistics.UsageStatisticsCollector;
import com.hivemq.statistics.UsageStatisticsSender;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatistics {
    private static final Logger log = LoggerFactory.getLogger(UsageStatistics.class);
    @NotNull
    private final UsageStatisticsCollector statisticsCollector;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final UsageStatisticsSender statisticsSender;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final FullConfigurationService configurationService;

    @Inject
    public UsageStatistics(@NotNull UsageStatisticsCollector statisticsCollector, @NotNull SystemInformation systemInformation, @NotNull UsageStatisticsSender statisticsSender, @NotNull FullConfigurationService configurationService, @NotNull ShutdownHooks shutdownHooks) {
        this.statisticsCollector = statisticsCollector;
        this.systemInformation = systemInformation;
        this.statisticsSender = statisticsSender;
        this.configurationService = configurationService;
        ThreadFactory threadFactory = ThreadFactoryUtil.create("usage-statistics-%d");
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        shutdownHooks.add(new HiveMQShutdownHook(){

            @Override
            @NotNull
            public String name() {
                return "Usage statistics shutdown";
            }

            @Override
            public void run() {
                UsageStatistics.this.stop();
            }
        });
    }

    public void start() {
        if (!this.configurationService.usageStatisticsConfiguration().isEnabled()) {
            return;
        }
        String hiveMQVersion = this.systemInformation.getHiveMQVersion();
        if (hiveMQVersion.equals("Development Snapshot") || hiveMQVersion.endsWith("SNAPSHOT")) {
            return;
        }
        this.scheduledExecutorService.execute(new SendStatisticsTask(this.statisticsSender, this.statisticsCollector, this.scheduledExecutorService, "startup"));
    }

    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }

    private static class SendStatisticsTask
    implements Runnable {
        @NotNull
        private final UsageStatisticsSender statisticsSender;
        @NotNull
        private final UsageStatisticsCollector statisticsCollector;
        @NotNull
        private final ScheduledExecutorService scheduledExecutorService;
        @NotNull
        private final String statisticType;

        private SendStatisticsTask(@NotNull UsageStatisticsSender statisticsSender, @NotNull UsageStatisticsCollector statisticsCollector, @NotNull ScheduledExecutorService scheduledExecutorService, @NotNull String statisticType) {
            this.statisticsSender = statisticsSender;
            this.statisticsCollector = statisticsCollector;
            this.scheduledExecutorService = scheduledExecutorService;
            this.statisticType = statisticType;
        }

        @Override
        public void run() {
            try {
                this.statisticsSender.sendStatistics(this.statisticsCollector.getJson(this.statisticType));
            }
            catch (Exception e) {
                log.debug("Not able to send anonymous user statistics, reason: {}", (Object)e.getMessage());
                log.trace("original exception", (Throwable)e);
            }
            finally {
                this.scheduledExecutorService.schedule(new SendStatisticsTask(this.statisticsSender, this.statisticsCollector, this.scheduledExecutorService, "runtime"), 1440L, TimeUnit.MINUTES);
            }
        }
    }
}

