/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics;

import com.codahale.metrics.Gauge;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.configuration.service.impl.listener.ListenerConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.statistics.HivemqId;
import com.hivemq.statistics.UsageStatisticsCollector;
import com.hivemq.statistics.collectors.CloudPlatform;
import com.hivemq.statistics.collectors.ContainerEnvironment;
import com.hivemq.statistics.entity.Statistic;
import java.util.Collection;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

@Singleton
public class UsageStatisticsCollectorImpl
implements UsageStatisticsCollector {
    private static final Logger log = LoggerFactory.getLogger(UsageStatisticsCollectorImpl.class);
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final FullConfigurationService fullConfigurationService;
    @NotNull
    private final MetricsHolder metricsHolder;
    @NotNull
    private final HivemqId hivemqId;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;

    @Inject
    public UsageStatisticsCollectorImpl(@NotNull SystemInformation systemInformation, @NotNull FullConfigurationService fullConfigurationService, @NotNull MetricsHolder metricsHolder, @NotNull HivemqId hivemqId, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.systemInformation = systemInformation;
        this.fullConfigurationService = fullConfigurationService;
        this.metricsHolder = metricsHolder;
        this.hivemqId = hivemqId;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    @Override
    @NotNull
    public String getJson(@NotNull String statisticsType) throws Exception {
        Statistic statistic = this.collectStatistics();
        statistic.setStatisticType(statisticsType);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writer().writeValueAsString((Object)statistic);
    }

    @NotNull
    private Statistic collectStatistics() {
        Statistic statistic = new Statistic();
        this.collectHiveMQInformation(statistic);
        try {
            this.collectSystemStatistics(statistic);
        }
        catch (Throwable t) {
            log.debug("Not able to fetch system information for anonymous statistics, reason: {}", (Object)t.getMessage());
            log.trace("original exception", t);
        }
        this.collectConfigStatistics(statistic);
        this.collectMetricStatistics(statistic);
        this.collectJvmStatistics(statistic);
        this.collectEnvironmentStatistics(statistic);
        return statistic;
    }

    private void collectEnvironmentStatistics(@NotNull Statistic statistic) {
        statistic.setCloudPlatform(new CloudPlatform().getCloudPlatform());
        statistic.setContainer(new ContainerEnvironment().getContainerEnvironment());
    }

    private void collectHiveMQInformation(@NotNull Statistic statistic) {
        statistic.setId(this.hivemqId.getHivemqId());
        statistic.setHivemqVersion(this.systemInformation.getHiveMQVersion());
        statistic.setHivemqUptime((System.currentTimeMillis() - this.systemInformation.getRunningSince()) / 1000L);
        int official = 0;
        int custom = 0;
        Collection<HiveMQExtension> extensions = this.hiveMQExtensions.getEnabledHiveMQExtensions().values();
        for (HiveMQExtension extension : extensions) {
            String author = extension.getAuthor();
            if (author != null && (author.contains("dc-square") || author.contains("HiveMQ"))) {
                ++official;
                continue;
            }
            ++custom;
        }
        statistic.setOfficialExtensions(official);
        statistic.setCustomExtensions(custom);
    }

    private void collectJvmStatistics(@NotNull Statistic statistic) {
        statistic.setJavaVendor(System.getProperty("java.vm.vendor"));
        statistic.setJavaVendorVersion(System.getProperty("java.vendor.version"));
        statistic.setJavaVersion(System.getProperty("java.version"));
        statistic.setJavaVersionDate(System.getProperty("java.version.date"));
        statistic.setJavaVirtualMachineName(System.getProperty("java.vm.name"));
        statistic.setJavaRuntimeName(System.getProperty("java.runtime.name"));
        statistic.setSystemArchitecture(System.getProperty("os.arch"));
    }

    private void collectMetricStatistics(@NotNull Statistic statistic) {
        Number connectedClients = (Number)this.getGaugeValue(HiveMQMetrics.CONNECTIONS_OVERALL_CURRENT.name());
        statistic.setConnectedClients(connectedClients == null ? 0L : connectedClients.longValue());
    }

    private void collectConfigStatistics(@NotNull Statistic statistic) {
        ListenerConfigurationService listenerConfiguration = this.fullConfigurationService.listenerConfiguration();
        statistic.setTcpListeners(listenerConfiguration.getTcpListeners().size());
        statistic.setTlsListeners(listenerConfiguration.getTlsTcpListeners().size());
        statistic.setWsListeners(listenerConfiguration.getWebsocketListeners().size());
        statistic.setWssListeners(listenerConfiguration.getTlsWebsocketListeners().size());
        MqttConfigurationService mqttConfigurationService = this.fullConfigurationService.mqttConfiguration();
        statistic.setMaxQueue(mqttConfigurationService.maxQueuedMessages());
        statistic.setMaxKeepalive(mqttConfigurationService.keepAliveMax());
        statistic.setSessionExpiry(mqttConfigurationService.maxSessionExpiryInterval());
        statistic.setMessageExpiry(mqttConfigurationService.maxMessageExpiryInterval());
        statistic.setConnectionThrottling(this.fullConfigurationService.restrictionsConfiguration().maxConnections());
        statistic.setBandwithIncoming(this.fullConfigurationService.restrictionsConfiguration().incomingLimit());
    }

    @Nullable
    private <T> T getGaugeValue(String metricName) {
        try {
            SortedMap gauges = this.metricsHolder.getMetricRegistry().getGauges((name, metric) -> metricName.equals(name));
            if (gauges.isEmpty()) {
                return null;
            }
            Gauge gauge = (Gauge)gauges.values().iterator().next();
            Object value = gauge.getValue();
            return (T)value;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void collectSystemStatistics(@NotNull Statistic statistic) {
        HardwareAbstractionLayer hardware;
        OperatingSystem operatingSystem;
        try {
            SystemInfo systemInfo = new SystemInfo();
            operatingSystem = systemInfo.getOperatingSystem();
            hardware = systemInfo.getHardware();
        }
        catch (UnsupportedOperationException e) {
            log.debug("system metrics are not supported, ignoring extended system information");
            log.trace("original exception", (Throwable)e);
            return;
        }
        statistic.setOsManufacturer(operatingSystem.getManufacturer());
        statistic.setOs(operatingSystem.getFamily());
        OperatingSystem.OSVersionInfo version = operatingSystem.getVersionInfo();
        statistic.setOsVersion(version.getVersion());
        statistic.setOpenFileLimit(operatingSystem.getFileSystem().getMaxFileDescriptors());
        long totalDiskSpace = 0L;
        for (OSFileStore osFileStore : operatingSystem.getFileSystem().getFileStores()) {
            totalDiskSpace += osFileStore.getTotalSpace() / 1024L / 1024L;
        }
        statistic.setDiskSize(totalDiskSpace);
        CentralProcessor processor = hardware.getProcessor();
        statistic.setCpu(processor.toString());
        statistic.setCpuSockets(processor.getPhysicalPackageCount());
        statistic.setCpuPhysicalCores(processor.getPhysicalProcessorCount());
        statistic.setCpuTotalCores(processor.getLogicalProcessorCount());
        statistic.setOsUptime(operatingSystem.getSystemUptime());
        statistic.setMemorySize(hardware.getMemory().getTotal() / 1024L / 1024L);
    }
}

