/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.statistics.UsageStatisticsSender;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatisticsSenderImpl
implements UsageStatisticsSender {
    private static final Logger log = LoggerFactory.getLogger(UsageStatisticsSenderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendStatistics(@Nullable String jsonPayload) {
        if (jsonPayload == null) {
            return;
        }
        String url = this.getUrl();
        HttpURLConnection connection = null;
        try {
            StringBuilder content;
            URL myurl = new URL(url);
            connection = (HttpURLConnection)myurl.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(30000);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("hmq-digest", BaseEncoding.base64().encode(Hashing.sha256().hashString((CharSequence)jsonPayload, StandardCharsets.UTF_8).asBytes()));
            connection.setRequestProperty("Content-Type", "application/json");
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.write(jsonPayload.getBytes(StandardCharsets.UTF_8));
                wr.flush();
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                content = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    content.append(line);
                    content.append(System.lineSeparator());
                }
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                log.debug("Unable to send statistics to server, response code:  {}", (Object)responseCode);
                log.trace("response content: {}", (Object)content.toString());
            } else {
                log.debug("Sent anonymous usage statistics");
            }
            try {
                connection.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                connection.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (connection != null) {
                try {
                    OutputStream outputStream = connection.getOutputStream();
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception outputStream) {
                    // empty catch block
                }
                try {
                    InputStream inputStream = connection.getInputStream();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            log.debug("Unable to send statistics to server: " + e.getMessage());
            log.trace("original exception", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @VisibleForTesting
    @NotNull
    String getUrl() {
        return "https://analytics.hivemq.com/v1";
    }
}

