/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.throttling.ioc;

import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.throttling.GlobalTrafficShaperExecutorShutdownHook;
import com.hivemq.util.ThreadFactoryUtil;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GlobalTrafficShapingProvider
implements Provider<GlobalTrafficShapingHandler> {
    private static final Logger log = LoggerFactory.getLogger(GlobalTrafficShapingProvider.class);
    @NotNull
    private final ShutdownHooks registry;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;

    @Inject
    GlobalTrafficShapingProvider(@NotNull ShutdownHooks registry, @NotNull RestrictionsConfigurationService restrictionsConfigurationService) {
        this.registry = registry;
        this.restrictionsConfigurationService = restrictionsConfigurationService;
    }

    @NotNull
    public GlobalTrafficShapingHandler get() {
        ThreadFactory threadFactory = ThreadFactoryUtil.create("global-traffic-shaper-executor-%d");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        GlobalTrafficShaperExecutorShutdownHook shutdownHook = new GlobalTrafficShaperExecutorShutdownHook(scheduledExecutorService);
        this.registry.add(shutdownHook);
        long incomingLimit = this.restrictionsConfigurationService.incomingLimit();
        log.debug("Throttling incoming traffic to {} B/s", (Object)incomingLimit);
        long outgoinglimit = 0L;
        log.debug("Throttling outgoing traffic to {} B/s", (Object)0L);
        return new GlobalTrafficShapingHandler(scheduledExecutorService, 0L, incomingLimit, 1000L);
    }
}

