/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Optional;

public class Bytes {
    private Bytes() {
    }

    public static boolean isBitSet(byte number, int bitPosition) {
        Preconditions.checkArgument((bitPosition < 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((bitPosition >= 0 ? 1 : 0) != 0);
        return (number & 1 << bitPosition) != 0;
    }

    public static byte setBit(byte number, int bitPosition, boolean value) {
        Preconditions.checkArgument((bitPosition < 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((bitPosition >= 0 ? 1 : 0) != 0);
        if (value) {
            return Bytes.setBit(number, bitPosition);
        }
        return Bytes.unsetBit(number, bitPosition);
    }

    public static byte setBit(byte number, int bitPosition) {
        Preconditions.checkArgument((bitPosition < 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((bitPosition >= 0 ? 1 : 0) != 0);
        return (byte)(number | 1 << bitPosition);
    }

    public static byte unsetBit(byte number, int bitPosition) {
        Preconditions.checkArgument((bitPosition < 8 ? 1 : 0) != 0);
        Preconditions.checkArgument((bitPosition >= 0 ? 1 : 0) != 0);
        return (byte)(number & ~(1 << bitPosition));
    }

    public static byte[] getPrefixedBytes(ByteBuf buf) {
        Preconditions.checkNotNull((Object)buf);
        if (buf.readableBytes() < 2) {
            return null;
        }
        int byteLength = buf.readUnsignedShort();
        if (buf.readableBytes() < byteLength) {
            return null;
        }
        byte[] rawBytes = new byte[byteLength];
        buf.readBytes(rawBytes);
        return rawBytes;
    }

    public static ByteBuf prefixBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }

    public static ByteBuf prefixBytes(byte[] bytes, ByteBuf buffer) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkNotNull((Object)buffer);
        buffer.writeShort(bytes.length);
        buffer.writeBytes(bytes);
        return buffer;
    }

    public static long readLong(byte[] buffer, int startPosition) {
        if (startPosition + 8 > buffer.length) {
            throw new IllegalArgumentException("The provided array[" + buffer.length + "] is to small to read 8 bytes from start position " + startPosition);
        }
        return Longs.fromBytes((byte)buffer[startPosition], (byte)buffer[startPosition + 1], (byte)buffer[startPosition + 2], (byte)buffer[startPosition + 3], (byte)buffer[startPosition + 4], (byte)buffer[startPosition + 5], (byte)buffer[startPosition + 6], (byte)buffer[startPosition + 7]);
    }

    public static int readInt(byte[] buffer, int startPosition) {
        if (startPosition + 4 > buffer.length) {
            throw new IllegalArgumentException("The provided array[" + buffer.length + "] is to small to read 4 bytes from start position " + startPosition);
        }
        return Ints.fromBytes((byte)buffer[startPosition], (byte)buffer[startPosition + 1], (byte)buffer[startPosition + 2], (byte)buffer[startPosition + 3]);
    }

    public static int readUnsignedShort(byte[] buffer, int startPosition) {
        if (startPosition + 2 > buffer.length) {
            throw new IllegalArgumentException("The provided array[" + buffer.length + "] is to small to read 2 bytes from start position " + startPosition);
        }
        return Ints.fromBytes((byte)0, (byte)0, (byte)buffer[startPosition], (byte)buffer[startPosition + 1]);
    }

    public static void copyIntToByteArray(int anInt, byte[] bytes, int prefix) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes must not be null");
        Preconditions.checkArgument((bytes.length >= prefix + 4 ? 1 : 0) != 0, (Object)"bytes needs to be at least prefix + 4 in length");
        Preconditions.checkArgument((prefix >= 0 ? 1 : 0) != 0, (Object)"prefix can't be less than 0");
        bytes[prefix] = (byte)(anInt >> 24);
        bytes[prefix + 1] = (byte)(anInt >> 16);
        bytes[prefix + 2] = (byte)(anInt >> 8);
        bytes[prefix + 3] = (byte)anInt;
    }

    public static void copyLongToByteArray(long aLong, byte[] bytes, int prefix) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes must not be null");
        Preconditions.checkArgument((bytes.length >= prefix + 8 ? 1 : 0) != 0, (Object)"bytes needs to be at least prefix + 8 in length");
        Preconditions.checkArgument((prefix >= 0 ? 1 : 0) != 0, (Object)"prefix can't be less than 0");
        bytes[prefix] = (byte)(aLong >> 56);
        bytes[prefix + 1] = (byte)(aLong >> 48);
        bytes[prefix + 2] = (byte)(aLong >> 40);
        bytes[prefix + 3] = (byte)(aLong >> 32);
        bytes[prefix + 4] = (byte)(aLong >> 24);
        bytes[prefix + 5] = (byte)(aLong >> 16);
        bytes[prefix + 6] = (byte)(aLong >> 8);
        bytes[prefix + 7] = (byte)aLong;
    }

    public static void copyUnsignedShortToByteArray(int unsignedShort, byte[] bytes, int prefix) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes must not be null");
        Preconditions.checkArgument((bytes.length >= prefix + 2 ? 1 : 0) != 0, (Object)"bytes needs to be at least prefix + 8 in length");
        Preconditions.checkArgument((prefix >= 0 ? 1 : 0) != 0, (Object)"prefix can't be less than 0");
        Preconditions.checkArgument((unsignedShort <= 65535 ? 1 : 0) != 0, (Object)"value must be less than 65535");
        Preconditions.checkArgument((unsignedShort >= 0 ? 1 : 0) != 0, (Object)"value must be more than 0");
        bytes[prefix] = (byte)(unsignedShort >> 8);
        bytes[prefix + 1] = (byte)unsignedShort;
    }

    @Nullable
    public static byte[] getBytesFromReadOnlyBuffer(@NotNull Optional<ByteBuffer> optional) {
        Preconditions.checkNotNull(optional, (Object)"optional must never be null");
        return optional.map(Bytes::fromReadOnlyBuffer).orElse(null);
    }

    @Nullable
    public static byte[] fromReadOnlyBuffer(@Nullable ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer rewind = byteBuffer.asReadOnlyBuffer().rewind();
        byte[] array = new byte[rewind.remaining()];
        rewind.get(array);
        return array;
    }
}

