/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.util.BatchedException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exceptions {
    private static final Logger log = LoggerFactory.getLogger(Exceptions.class);

    public static void rethrowError(@NotNull String text, @NotNull Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        log.error(text, throwable);
    }

    public static void rethrowError(@NotNull Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static boolean isConnectionClosedException(@NotNull Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        if (throwable instanceof BatchedException) {
            BatchedException batchedException = (BatchedException)throwable;
            for (Throwable inner : batchedException.getThrowables()) {
                if (inner instanceof ClosedChannelException) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

