/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtils {
    private static final Logger log = LoggerFactory.getLogger(ManifestUtils.class);

    public static String getValueFromManifest(Class clazz, String name) {
        try {
            URL resource = ManifestUtils.getResource(clazz, "META-INF/MANIFEST.MF");
            if (resource == null) {
                return null;
            }
            Manifest manifest = new Manifest(resource.openStream());
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @VisibleForTesting
    public static URL getResource(Class clazz, String resourcePath) {
        try {
            if (clazz == null || resourcePath == null) {
                return null;
            }
            ClassLoader cl = clazz.getClassLoader();
            Enumeration<URL> resources = cl.getResources(resourcePath);
            ArrayList<URL> urls = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
            if (urls.isEmpty()) {
                return null;
            }
            URL url = null;
            if (urls.size() == 1) {
                url = (URL)urls.get(0);
            } else {
                for (URL currentUrl : urls) {
                    if (!currentUrl.getPath().contains("hivemq.jar")) continue;
                    url = currentUrl;
                    break;
                }
                if (url == null) {
                    url = (URL)urls.get(0);
                }
            }
            return url;
        }
        catch (IOException e) {
            log.warn("Could not read resource " + resourcePath);
            log.debug("Original exception: ", (Throwable)e);
            return null;
        }
    }
}

