/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.woff2;

import com.itextpdf.io.font.woff2.JavaUnsignedUtil;

class Woff2Common {
    public static final int kWoff2Signature = 2001684018;
    public static final int kWoff2FlagsTransform = 256;
    public static final int kTtcFontFlavor = 1953784678;
    public static final int kSfntHeaderSize = 12;
    public static final int kSfntEntrySize = 16;

    Woff2Common() {
    }

    public static int collectionHeaderSize(int header_version, int num_fonts) {
        int size = 0;
        if (header_version == 131072) {
            size += 12;
        }
        if (header_version == 65536 || header_version == 131072) {
            size += 12 + 4 * num_fonts;
        }
        return size;
    }

    public static int computeULongSum(byte[] buf, int offset, int size) {
        int checksum = 0;
        int aligned_size = size & 0xFFFFFFFC;
        for (int i = 0; i < aligned_size; i += 4) {
            checksum += JavaUnsignedUtil.asU8(buf[offset + i]) << 24 | JavaUnsignedUtil.asU8(buf[offset + i + 1]) << 16 | JavaUnsignedUtil.asU8(buf[offset + i + 2]) << 8 | JavaUnsignedUtil.asU8(buf[offset + i + 3]);
        }
        if (size != aligned_size) {
            int v = 0;
            for (int i = aligned_size; i < size; ++i) {
                v |= JavaUnsignedUtil.asU8(buf[offset + i]) << 24 - 8 * (i & 3);
            }
            checksum += v;
        }
        return checksum;
    }

    public static class Table
    implements Comparable<Table> {
        public int tag;
        public int flags;
        public int src_offset;
        public int src_length;
        public int transform_length;
        public int dst_offset;
        public int dst_length;

        @Override
        public int compareTo(Table o) {
            return JavaUnsignedUtil.compareAsUnsigned(this.tag, o.tag);
        }
    }

    public static class Point {
        public int x;
        public int y;
        public boolean on_curve;

        public Point(int x, int y, boolean on_curve) {
            this.x = x;
            this.y = y;
            this.on_curve = on_curve;
        }
    }
}

