/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.AdobeGlyphList;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.Type1Parser;
import com.itextpdf.io.font.constants.FontWeights;
import com.itextpdf.io.font.constants.StandardFonts;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type1Font
extends FontProgram {
    private static final long serialVersionUID = -1078208220942939920L;
    private Type1Parser fontParser;
    private String characterSet;
    private Map<Long, Integer> kernPairs = new HashMap<Long, Integer>();
    private static final int[] PFB_TYPES = new int[]{1, 2, 1};
    private byte[] fontStreamBytes;
    private int[] fontStreamLengths;

    protected static Type1Font createStandardFont(String name) throws java.io.IOException {
        if (StandardFonts.isStandardFont(name)) {
            return new Type1Font(name, null, null, null);
        }
        throw new IOException("{0} is not a standard type1 font.").setMessageParams(name);
    }

    protected Type1Font() {
        this.fontNames = new FontNames();
    }

    protected Type1Font(String metricsPath, String binaryPath, byte[] afm, byte[] pfb) throws java.io.IOException {
        this();
        this.fontParser = new Type1Parser(metricsPath, binaryPath, afm, pfb);
        this.process();
    }

    protected Type1Font(String baseFont) {
        this();
        this.getFontNames().setFontName(baseFont);
    }

    public boolean isBuiltInFont() {
        return this.fontParser != null && this.fontParser.isBuiltInFont();
    }

    @Override
    public int getPdfFontFlags() {
        int flags = 0;
        if (this.fontMetrics.isFixedPitch()) {
            flags |= 1;
        }
        flags |= this.isFontSpecific() ? 4 : 32;
        if (this.fontMetrics.getItalicAngle() < 0.0f) {
            flags |= 0x40;
        }
        if (this.fontNames.getFontName().contains("Caps") || this.fontNames.getFontName().endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.fontNames.isBold() || this.fontNames.getFontWeight() > 500) {
            flags |= 0x40000;
        }
        return flags;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    @Override
    public boolean hasKernPairs() {
        return this.kernPairs.size() > 0;
    }

    @Override
    public int getKerning(Glyph first, Glyph second) {
        if (first.hasValidUnicode() && second.hasValidUnicode()) {
            long record = ((long)first.getUnicode() << 32) + (long)second.getUnicode();
            if (this.kernPairs.containsKey(record)) {
                return this.kernPairs.get(record);
            }
            return 0;
        }
        return 0;
    }

    public boolean setKerning(int first, int second, int kern) {
        long record = ((long)first << 32) + (long)second;
        this.kernPairs.put(record, kern);
        return true;
    }

    public Glyph getGlyph(String name) {
        int unicode = AdobeGlyphList.nameToUnicode(name);
        if (unicode != -1) {
            return this.getGlyph(unicode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFontStreamBytes() {
        if (this.fontParser.isBuiltInFont()) {
            return null;
        }
        if (this.fontStreamBytes != null) {
            return this.fontStreamBytes;
        }
        RandomAccessFileOrArray raf = null;
        try {
            raf = this.fontParser.getPostscriptBinary();
            int fileLength = (int)raf.length();
            this.fontStreamBytes = new byte[fileLength - 18];
            this.fontStreamLengths = new int[3];
            int bytePtr = 0;
            int k = 0;
            while (true) {
                int size;
                if (k < 3) {
                    if (raf.read() != 128) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("Start marker is missing in the pfb file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    if (raf.read() != PFB_TYPES[k]) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("incorrect.segment.type.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    size = raf.read();
                    size += raf.read() << 8;
                    size += raf.read() << 16;
                    this.fontStreamLengths[k] = size += raf.read() << 24;
                } else {
                    byte[] byArray = this.fontStreamBytes;
                    return byArray;
                }
                while (size != 0) {
                    int got = raf.read(this.fontStreamBytes, bytePtr, size);
                    if (got < 0) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("premature.end.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    bytePtr += got;
                    size -= got;
                }
                ++k;
            }
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(Type1Font.class);
            logger.error("type1.font.file.exception");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int[] getFontStreamLengths() {
        return this.fontStreamLengths;
    }

    protected void process() throws java.io.IOException {
        String metricsPath;
        StringTokenizer tok;
        Glyph space;
        String line;
        RandomAccessFileOrArray raf = this.fontParser.getMetricsFile();
        boolean startKernPairs = false;
        while (!startKernPairs && (line = raf.readLine()) != null) {
            String ident;
            StringTokenizer tok2 = new StringTokenizer(line, " ,\n\r\t\f");
            if (!tok2.hasMoreTokens()) continue;
            switch (ident = tok2.nextToken()) {
                case "FontName": {
                    this.fontNames.setFontName(tok2.nextToken("\u00ff").substring(1));
                    break;
                }
                case "FullName": {
                    String fullName = tok2.nextToken("\u00ff").substring(1);
                    this.fontNames.setFullName(new String[][]{{"", "", "", fullName}});
                    break;
                }
                case "FamilyName": {
                    String familyName = tok2.nextToken("\u00ff").substring(1);
                    this.fontNames.setFamilyName(new String[][]{{"", "", "", familyName}});
                    break;
                }
                case "Weight": {
                    this.fontNames.setFontWeight(FontWeights.fromType1FontWeight(tok2.nextToken("\u00ff").substring(1)));
                    break;
                }
                case "ItalicAngle": {
                    this.fontMetrics.setItalicAngle(Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "IsFixedPitch": {
                    this.fontMetrics.setIsFixedPitch(tok2.nextToken().equals("true"));
                    break;
                }
                case "CharacterSet": {
                    this.characterSet = tok2.nextToken("\u00ff").substring(1);
                    break;
                }
                case "FontBBox": {
                    int llx = (int)Float.parseFloat(tok2.nextToken());
                    int lly = (int)Float.parseFloat(tok2.nextToken());
                    int urx = (int)Float.parseFloat(tok2.nextToken());
                    int ury = (int)Float.parseFloat(tok2.nextToken());
                    this.fontMetrics.setBbox(llx, lly, urx, ury);
                    break;
                }
                case "UnderlinePosition": {
                    this.fontMetrics.setUnderlinePosition((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "UnderlineThickness": {
                    this.fontMetrics.setUnderlineThickness((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "EncodingScheme": {
                    this.encodingScheme = tok2.nextToken("\u00ff").substring(1).trim();
                    break;
                }
                case "CapHeight": {
                    this.fontMetrics.setCapHeight((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "XHeight": {
                    this.fontMetrics.setXHeight((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "Ascender": {
                    this.fontMetrics.setTypoAscender((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "Descender": {
                    this.fontMetrics.setTypoDescender((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "StdHW": {
                    this.fontMetrics.setStemH((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "StdVW": {
                    this.fontMetrics.setStemV((int)Float.parseFloat(tok2.nextToken()));
                    break;
                }
                case "StartCharMetrics": {
                    startKernPairs = true;
                }
            }
        }
        if (!startKernPairs) {
            String metricsPath2 = this.fontParser.getAfmPath();
            if (metricsPath2 != null) {
                throw new IOException("startcharmetrics is missing in {0}.").setMessageParams(metricsPath2);
            }
            throw new IOException("startcharmetrics is missing in the metrics file.");
        }
        this.avgWidth = 0;
        int widthCount = 0;
        while ((line = raf.readLine()) != null) {
            StringTokenizer tok3 = new StringTokenizer(line);
            if (!tok3.hasMoreTokens()) continue;
            String ident = tok3.nextToken();
            if (ident.equals("EndCharMetrics")) {
                startKernPairs = false;
                break;
            }
            int C = -1;
            int WX = 250;
            String N = "";
            int[] B = null;
            tok3 = new StringTokenizer(line, ";");
            while (tok3.hasMoreTokens()) {
                StringTokenizer tokc = new StringTokenizer(tok3.nextToken());
                if (!tokc.hasMoreTokens()) continue;
                switch (ident = tokc.nextToken()) {
                    case "C": {
                        C = Integer.parseInt(tokc.nextToken());
                        break;
                    }
                    case "WX": {
                        WX = (int)Float.parseFloat(tokc.nextToken());
                        break;
                    }
                    case "N": {
                        N = tokc.nextToken();
                        break;
                    }
                    case "B": {
                        B = new int[]{Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken())};
                    }
                }
            }
            int unicode = AdobeGlyphList.nameToUnicode(N);
            Glyph glyph = new Glyph(C, WX, unicode, B);
            if (C >= 0) {
                this.codeToGlyph.put(C, glyph);
            }
            if (unicode != -1) {
                this.unicodeToGlyph.put(unicode, glyph);
            }
            this.avgWidth += WX;
            ++widthCount;
        }
        if (widthCount != 0) {
            this.avgWidth /= widthCount;
        }
        if (startKernPairs) {
            String metricsPath3 = this.fontParser.getAfmPath();
            if (metricsPath3 != null) {
                throw new IOException("endcharmetrics is missing in {0}.").setMessageParams(metricsPath3);
            }
            throw new IOException("endcharmetrics is missing in the metrics file.");
        }
        if (!this.unicodeToGlyph.containsKey(160) && (space = (Glyph)this.unicodeToGlyph.get(32)) != null) {
            this.unicodeToGlyph.put(160, new Glyph(space.getCode(), space.getWidth(), 160, space.getBbox()));
        }
        boolean endOfMetrics = false;
        while ((line = raf.readLine()) != null) {
            tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            String ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                endOfMetrics = true;
                break;
            }
            if (!ident.equals("StartKernPairs")) continue;
            startKernPairs = true;
            break;
        }
        if (startKernPairs) {
            while ((line = raf.readLine()) != null) {
                tok = new StringTokenizer(line);
                if (!tok.hasMoreTokens()) continue;
                String ident = tok.nextToken();
                if (ident.equals("KPX")) {
                    String first = tok.nextToken();
                    String second = tok.nextToken();
                    Integer width = (int)Float.parseFloat(tok.nextToken());
                    int firstUni = AdobeGlyphList.nameToUnicode(first);
                    int secondUni = AdobeGlyphList.nameToUnicode(second);
                    if (firstUni == -1 || secondUni == -1) continue;
                    long record = ((long)firstUni << 32) + (long)secondUni;
                    this.kernPairs.put(record, width);
                    continue;
                }
                if (!ident.equals("EndKernPairs")) continue;
                startKernPairs = false;
                break;
            }
        } else if (!endOfMetrics) {
            metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("endfontmetrics is missing in {0}.").setMessageParams(metricsPath);
            }
            throw new IOException("endfontmetrics is missing in the metrics file.");
        }
        if (startKernPairs) {
            metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("endkernpairs is missing in {0}.").setMessageParams(metricsPath);
            }
            throw new IOException("endkernpairs is missing in the metrics file.");
        }
        raf.close();
        this.isFontSpecific = !this.encodingScheme.equals("AdobeStandardEncoding") && !this.encodingScheme.equals("StandardEncoding");
    }
}

