/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel;

import java.lang.reflect.Method;

public final class Version {
    private static String AGPL = " (AGPL-version)";
    private static Version version = null;
    private static String iText = "iText\u00ae";
    private static String release = "7.0.3";
    private String iTextVersion = iText + " " + release + " \u00a92000-2017 iText Group NV";
    private String key = null;
    private boolean expired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getInstance() {
        if (version == null) {
            Version version = Version.version = new Version();
            synchronized (version) {
                try {
                    String licenseeInfoMethodName = "getLicenseeInfo";
                    Class<?> klass = Version.getLicenseKeyClass();
                    if (klass != null) {
                        Method m = klass.getMethod(licenseeInfoMethodName, new Class[0]);
                        String[] info = (String[])m.invoke(klass.newInstance(), null);
                        if (info[3] != null && info[3].trim().length() > 0) {
                            Version.version.key = info[3];
                        } else {
                            Version.version.key = "Trial version ";
                            Version.version.key = info[5] == null ? Version.version.key + "unauthorised" : Version.version.key + info[5];
                        }
                        if (info.length > 6 && info[6] != null && info[6].trim().length() > 0 && !release.startsWith(info[6])) {
                            throw new IllegalArgumentException("Your license key version doesn't match the iText version.");
                        }
                        if (info[4] != null && info[4].trim().length() > 0) {
                            Version.version.iTextVersion = info[4];
                        } else if (info[2] != null && info[2].trim().length() > 0) {
                            Version.version.addLicensedPostfix(info[2]);
                        } else if (info[0] != null && info[0].trim().length() > 0) {
                            Version.version.addLicensedPostfix(info[0]);
                        } else {
                            Version.version.addAGPLPostfix(null);
                        }
                    } else {
                        Version.version.addAGPLPostfix(null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    Version.version.addAGPLPostfix(iae.getCause());
                }
                catch (Exception e) {
                    Version.version.addAGPLPostfix(e.getCause());
                }
            }
        }
        return version;
    }

    public static boolean isAGPLVersion() {
        return Version.getInstance().getVersion().indexOf(AGPL) > 0;
    }

    public static boolean isExpired() {
        return Version.getInstance().expired;
    }

    public String getProduct() {
        return iText;
    }

    public String getRelease() {
        return release;
    }

    public String getVersion() {
        return this.iTextVersion;
    }

    public String getKey() {
        return this.key;
    }

    private void addLicensedPostfix(String ownerName) {
        this.iTextVersion = this.iTextVersion + " (" + ownerName;
        this.iTextVersion = !this.key.toLowerCase().startsWith("trial") ? this.iTextVersion + "; licensed version)" : this.iTextVersion + "; " + this.key + ")";
    }

    private void addAGPLPostfix(Throwable cause) {
        this.iTextVersion = this.iTextVersion + AGPL;
        if (cause != null && cause.getMessage() != null && cause.getMessage().contains("expired")) {
            this.expired = true;
        }
    }

    private static Class<?> getLicenseKeyClass() throws ClassNotFoundException {
        String licenseKeyClassFullName = "com.itextpdf.licensekey.LicenseKey";
        return Class.forName(licenseKeyClassFullName);
    }
}

