/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public class AESCipherCBCnoPad {
    private BlockCipher cbc;

    public AESCipherCBCnoPad(boolean forEncryption, byte[] key) {
        AESFastEngine aes = new AESFastEngine();
        this.cbc = new CBCBlockCipher((BlockCipher)aes);
        KeyParameter kp = new KeyParameter(key);
        this.cbc.init(forEncryption, (CipherParameters)kp);
    }

    public byte[] processBlock(byte[] inp, int inpOff, int inpLen) {
        if (inpLen % this.cbc.getBlockSize() != 0) {
            throw new IllegalArgumentException("Not multiple of block: " + inpLen);
        }
        byte[] outp = new byte[inpLen];
        int baseOffset = 0;
        while (inpLen > 0) {
            this.cbc.processBlock(inp, inpOff, outp, baseOffset);
            inpLen -= this.cbc.getBlockSize();
            baseOffset += this.cbc.getBlockSize();
            inpOff += this.cbc.getBlockSize();
        }
        return outp;
    }
}

