/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class PdfSimpleFont<T extends FontProgram>
extends PdfFont {
    private static final long serialVersionUID = -4942318223894676176L;
    protected FontEncoding fontEncoding;
    protected boolean forceWidthsOutput = false;
    protected byte[] shortTag = new byte[256];

    protected PdfSimpleFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
    }

    protected PdfSimpleFont() {
    }

    @Override
    public GlyphLine createGlyphLine(String content) {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(content.length());
        if (this.fontEncoding.isFontSpecific()) {
            for (int i = 0; i < content.length(); ++i) {
                Glyph glyph = this.fontProgram.getGlyphByCode((int)content.charAt(i));
                if (glyph == null) continue;
                glyphs.add(glyph);
            }
        } else {
            for (int i = 0; i < content.length(); ++i) {
                Glyph glyph = this.getGlyph(content.charAt(i));
                if (glyph == null) continue;
                glyphs.add(glyph);
            }
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public int appendGlyphs(String text, int from, int to, List<Glyph> glyphs) {
        int processed = 0;
        if (this.fontEncoding.isFontSpecific()) {
            Glyph glyph;
            for (int i = from; i <= to && (glyph = this.fontProgram.getGlyphByCode(text.charAt(i) & 0xFF)) != null; ++i) {
                glyphs.add(glyph);
                ++processed;
            }
        } else {
            Glyph glyph;
            for (int i = from; i <= to && (glyph = this.getGlyph(text.charAt(i))) != null && (this.containsGlyph(text, i) || this.isAppendableGlyph(glyph)); ++i) {
                glyphs.add(glyph);
                ++processed;
            }
        }
        return processed;
    }

    @Override
    public int appendAnyGlyph(String text, int from, List<Glyph> glyphs) {
        Glyph glyph = this.fontEncoding.isFontSpecific() ? this.fontProgram.getGlyphByCode((int)text.charAt(from)) : this.getGlyph(text.charAt(from));
        if (glyph != null) {
            glyphs.add(glyph);
        }
        return 1;
    }

    private boolean isAppendableGlyph(Glyph glyph) {
        return glyph.getCode() > 0 || TextUtil.isWhitespaceOrNonPrintable((int)glyph.getUnicode());
    }

    public T getFontProgram() {
        return (T)this.fontProgram;
    }

    public FontEncoding getFontEncoding() {
        return this.fontEncoding;
    }

    @Override
    public byte[] convertToBytes(String text) {
        byte[] bytes;
        for (byte b : bytes = this.fontEncoding.convertToBytes(text)) {
            this.shortTag[b & 0xFF] = 1;
        }
        return bytes;
    }

    @Override
    public byte[] convertToBytes(GlyphLine glyphLine) {
        if (glyphLine != null) {
            int i;
            byte[] bytes = new byte[glyphLine.size()];
            int ptr = 0;
            if (this.fontEncoding.isFontSpecific()) {
                for (i = 0; i < glyphLine.size(); ++i) {
                    bytes[ptr++] = (byte)glyphLine.get(i).getCode();
                }
            } else {
                for (i = 0; i < glyphLine.size(); ++i) {
                    if (!this.fontEncoding.canEncode(glyphLine.get(i).getUnicode())) continue;
                    bytes[ptr++] = (byte)this.fontEncoding.convertToByte(glyphLine.get(i).getUnicode());
                }
            }
            for (byte b : bytes = ArrayUtil.shortenArray((byte[])bytes, (int)ptr)) {
                this.shortTag[b & 0xFF] = 1;
            }
            return bytes;
        }
        return emptyBytes;
    }

    @Override
    public byte[] convertToBytes(Glyph glyph) {
        byte[] bytes = new byte[1];
        if (this.fontEncoding.isFontSpecific()) {
            bytes[0] = (byte)glyph.getCode();
        } else if (this.fontEncoding.canEncode(glyph.getUnicode())) {
            bytes[0] = (byte)this.fontEncoding.convertToByte(glyph.getUnicode());
        } else {
            return emptyBytes;
        }
        this.shortTag[bytes[0] & 0xFF] = 1;
        return bytes;
    }

    @Override
    public void writeText(GlyphLine text, int from, int to, PdfOutputStream stream) {
        int i;
        byte[] bytes = new byte[to - from + 1];
        int ptr = 0;
        if (this.fontEncoding.isFontSpecific()) {
            for (i = from; i <= to; ++i) {
                bytes[ptr++] = (byte)text.get(i).getCode();
            }
        } else {
            for (i = from; i <= to; ++i) {
                if (!this.fontEncoding.canEncode(text.get(i).getUnicode())) continue;
                bytes[ptr++] = (byte)this.fontEncoding.convertToByte(text.get(i).getUnicode());
            }
        }
        for (byte b : bytes = ArrayUtil.shortenArray((byte[])bytes, (int)ptr)) {
            this.shortTag[b & 0xFF] = 1;
        }
        StreamUtil.writeEscapedString((OutputStream)((Object)stream), (byte[])bytes);
    }

    @Override
    public void writeText(String text, PdfOutputStream stream) {
        StreamUtil.writeEscapedString((OutputStream)((Object)stream), (byte[])this.convertToBytes(text));
    }

    @Override
    public String decode(PdfString content) {
        byte[] contentBytes = content.getValueBytes();
        StringBuilder builder = new StringBuilder(contentBytes.length);
        for (byte b : contentBytes) {
            Glyph glyph;
            int uni = this.fontEncoding.getUnicode(b & 0xFF);
            if (uni > -1) {
                builder.append((char)uni);
                continue;
            }
            if (this.fontEncoding.getBaseEncoding() != null || (glyph = this.fontProgram.getGlyphByCode(b & 0xFF)) == null || glyph.getChars() == null) continue;
            builder.append(glyph.getChars());
        }
        return builder.toString();
    }

    @Override
    public GlyphLine decodeIntoGlyphLine(PdfString content) {
        byte[] contentBytes = content.getValueBytes();
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(contentBytes.length);
        for (byte b : contentBytes) {
            int code = b & 0xFF;
            int uni = this.fontEncoding.getUnicode(code);
            Glyph glyph = null;
            if (uni > -1) {
                glyph = this.getGlyph(uni);
            } else if (this.fontEncoding.getBaseEncoding() == null) {
                glyph = this.fontProgram.getGlyphByCode(code);
            }
            if (glyph == null) continue;
            glyphs.add(glyph);
        }
        return new GlyphLine(glyphs);
    }

    @Override
    public float getContentWidth(PdfString content) {
        byte[] contentBytes;
        float width = 0.0f;
        for (byte b : contentBytes = content.getValueBytes()) {
            Glyph glyph = null;
            int uni = this.fontEncoding.getUnicode(b & 0xFF);
            if (uni > -1) {
                glyph = this.getGlyph(uni);
            } else if (this.fontEncoding.getBaseEncoding() == null) {
                glyph = this.fontProgram.getGlyphByCode(b & 0xFF);
            }
            width += glyph != null ? (float)glyph.getWidth() : 0.0f;
        }
        return width;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean forceWidthsOutput) {
        this.forceWidthsOutput = forceWidthsOutput;
    }

    protected void flushFontData(String fontName, PdfName subtype) {
        PdfDictionary fontDescriptor;
        int k;
        int lastChar;
        int firstChar;
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, subtype);
        if (fontName != null) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.BaseFont, new PdfName(fontName));
        }
        for (firstChar = 0; firstChar < 256 && this.shortTag[firstChar] == 0; ++firstChar) {
        }
        for (lastChar = 255; lastChar >= firstChar && this.shortTag[lastChar] == 0; --lastChar) {
        }
        if (firstChar > 255) {
            firstChar = 255;
            lastChar = 255;
        }
        if (!this.isSubset() || !this.isEmbedded()) {
            firstChar = 0;
            lastChar = this.shortTag.length - 1;
            for (k = 0; k < this.shortTag.length; ++k) {
                this.shortTag[k] = this.fontEncoding.canDecode(k) ? (byte)1 : (!this.fontEncoding.hasDifferences() && this.fontProgram.getGlyphByCode(k) != null ? (byte)1 : 0);
            }
        }
        if (this.fontEncoding.hasDifferences()) {
            for (k = firstChar; k <= lastChar; ++k) {
                if (".notdef".equals(this.fontEncoding.getDifference(k))) continue;
                firstChar = k;
                break;
            }
            for (k = lastChar; k >= firstChar; --k) {
                if (".notdef".equals(this.fontEncoding.getDifference(k))) continue;
                lastChar = k;
                break;
            }
            PdfDictionary enc = new PdfDictionary();
            enc.put(PdfName.Type, PdfName.Encoding);
            PdfArray diff = new PdfArray();
            boolean gap = true;
            for (int k2 = firstChar; k2 <= lastChar; ++k2) {
                if (this.shortTag[k2] != 0) {
                    if (gap) {
                        diff.add(new PdfNumber(k2));
                        gap = false;
                    }
                    diff.add(new PdfName(this.fontEncoding.getDifference(k2)));
                    continue;
                }
                gap = true;
            }
            enc.put(PdfName.Differences, diff);
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, enc);
        } else if (!this.fontEncoding.isFontSpecific()) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Encoding, "Cp1252".equals(this.fontEncoding.getBaseEncoding()) ? PdfName.WinAnsiEncoding : PdfName.MacRomanEncoding);
        }
        if (this.isForceWidthsOutput() || !this.isBuiltInFont() || this.fontEncoding.hasDifferences()) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.FirstChar, new PdfNumber(firstChar));
            ((PdfDictionary)this.getPdfObject()).put(PdfName.LastChar, new PdfNumber(lastChar));
            PdfArray wd = new PdfArray();
            for (int k3 = firstChar; k3 <= lastChar; ++k3) {
                if (this.shortTag[k3] == 0) {
                    wd.add(new PdfNumber(0));
                    continue;
                }
                int uni = this.fontEncoding.getUnicode(k3);
                Glyph glyph = uni > -1 ? this.getGlyph(uni) : this.fontProgram.getGlyphByCode(k3);
                wd.add(new PdfNumber(glyph != null ? glyph.getWidth() : 0));
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Widths, wd);
        }
        PdfDictionary pdfDictionary = fontDescriptor = !this.isBuiltInFont() ? this.getFontDescriptor(fontName) : null;
        if (fontDescriptor != null) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.FontDescriptor, fontDescriptor);
            if (fontDescriptor.getIndirectReference() != null) {
                fontDescriptor.flush();
            }
        }
    }

    protected boolean isBuiltInFont() {
        return false;
    }

    @Override
    protected PdfDictionary getFontDescriptor(String fontName) {
        FontMetrics fontMetrics = this.fontProgram.getFontMetrics();
        FontNames fontNames = this.fontProgram.getFontNames();
        PdfDictionary fontDescriptor = new PdfDictionary();
        this.makeObjectIndirect(fontDescriptor);
        fontDescriptor.put(PdfName.Type, PdfName.FontDescriptor);
        fontDescriptor.put(PdfName.FontName, new PdfName(fontName));
        fontDescriptor.put(PdfName.Ascent, new PdfNumber(fontMetrics.getTypoAscender()));
        fontDescriptor.put(PdfName.CapHeight, new PdfNumber(fontMetrics.getCapHeight()));
        fontDescriptor.put(PdfName.Descent, new PdfNumber(fontMetrics.getTypoDescender()));
        fontDescriptor.put(PdfName.FontBBox, new PdfArray(ArrayUtil.cloneArray((int[])fontMetrics.getBbox())));
        fontDescriptor.put(PdfName.ItalicAngle, new PdfNumber(fontMetrics.getItalicAngle()));
        fontDescriptor.put(PdfName.StemV, new PdfNumber(fontMetrics.getStemV()));
        if (fontMetrics.getXHeight() > 0) {
            fontDescriptor.put(PdfName.XHeight, new PdfNumber(fontMetrics.getXHeight()));
        }
        if (fontMetrics.getStemH() > 0) {
            fontDescriptor.put(PdfName.StemH, new PdfNumber(fontMetrics.getStemH()));
        }
        if (fontNames.getFontWeight() > 0) {
            fontDescriptor.put(PdfName.FontWeight, new PdfNumber(fontNames.getFontWeight()));
        }
        if (fontNames.getFamilyName() != null && fontNames.getFamilyName().length > 0 && fontNames.getFamilyName()[0].length >= 4) {
            fontDescriptor.put(PdfName.FontFamily, new PdfString(fontNames.getFamilyName()[0][3]));
        }
        this.addFontStream(fontDescriptor);
        int flags = this.fontProgram.getPdfFontFlags();
        if (this.fontProgram.isFontSpecific() != this.fontEncoding.isFontSpecific()) {
            flags &= 0xFFFFFFDB;
            flags |= this.fontEncoding.isFontSpecific() ? 4 : 32;
        }
        fontDescriptor.put(PdfName.Flags, new PdfNumber(flags));
        return fontDescriptor;
    }

    protected abstract void addFontStream(PdfDictionary var1);

    protected void setFontProgram(T fontProgram) {
        this.fontProgram = fontProgram;
    }
}

