/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.layer;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.layer.PdfLayer;
import com.itextpdf.kernel.pdf.layer.PdfVisibilityExpression;
import java.util.ArrayList;
import java.util.Collection;

public class PdfLayerMembership
extends PdfObjectWrapper<PdfDictionary>
implements IPdfOCG {
    private static final long serialVersionUID = -597407628148657784L;

    public PdfLayerMembership(PdfDocument doc) {
        super(new PdfDictionary());
        this.makeIndirect(doc);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.OCMD);
    }

    public PdfLayerMembership(PdfDictionary membershipDictionary) {
        super(membershipDictionary);
        PdfLayerMembership.ensureObjectIsAddedToDocument(membershipDictionary);
        if (!PdfName.OCMD.equals(membershipDictionary.getAsName(PdfName.Type))) {
            throw new IllegalArgumentException("Invalid membershipDictionary.");
        }
    }

    public Collection<PdfLayer> getLayers() {
        PdfObject layers = ((PdfDictionary)this.getPdfObject()).get(PdfName.OCGs);
        if (layers instanceof PdfDictionary) {
            ArrayList<PdfLayer> list = new ArrayList<PdfLayer>();
            list.add(new PdfLayer(((PdfDictionary)layers).makeIndirect(this.getDocument())));
            return list;
        }
        if (layers instanceof PdfArray) {
            ArrayList<PdfLayer> layerList = new ArrayList<PdfLayer>();
            for (int ind = 0; ind < ((PdfArray)layers).size(); ++ind) {
                layerList.add(new PdfLayer(((PdfArray)layers).makeIndirect(this.getDocument()).getAsDictionary(ind)));
            }
            return layerList;
        }
        return null;
    }

    public void addLayer(PdfLayer layer) {
        PdfArray layers = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.OCGs);
        if (layers == null) {
            layers = new PdfArray();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.OCGs, layers);
        }
        layers.add((PdfObject)layer.getPdfObject());
        layers.setModified();
    }

    public void setVisibilityPolicy(PdfName visibilityPolicy) {
        if (visibilityPolicy == null || !PdfName.AllOn.equals(visibilityPolicy) && !PdfName.AnyOn.equals(visibilityPolicy) && !PdfName.AnyOff.equals(visibilityPolicy) && !PdfName.AllOff.equals(visibilityPolicy)) {
            throw new IllegalArgumentException("Argument: visibilityPolicy");
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.P, visibilityPolicy);
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public PdfName getVisibilityPolicy() {
        PdfName visibilityPolicy = ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.P);
        if (visibilityPolicy == null || !visibilityPolicy.equals(PdfName.AllOn) && !visibilityPolicy.equals(PdfName.AllOff) && !visibilityPolicy.equals(PdfName.AnyOn) && !visibilityPolicy.equals(PdfName.AnyOff)) {
            return PdfName.AnyOn;
        }
        return visibilityPolicy;
    }

    public void setVisibilityExpression(PdfVisibilityExpression visibilityExpression) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.VE, (PdfObject)visibilityExpression.getPdfObject());
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public PdfVisibilityExpression getVisibilityExpression() {
        PdfArray ve = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.VE);
        return ve != null ? new PdfVisibilityExpression(ve) : null;
    }

    @Override
    public PdfIndirectReference getIndirectReference() {
        ((PdfDictionary)this.getPdfObject()).makeIndirect(this.getDocument());
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }
}

