/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagging.IPdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfMcr;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TagStructureContext
implements Serializable {
    private static final long serialVersionUID = -7870069015800895036L;
    private static final Set<PdfName> allowedRootTagRoles = new HashSet<PdfName>();
    private PdfDocument document;
    private PdfStructElem rootTagElement;
    protected TagTreePointer autoTaggingPointer;
    private PdfVersion tagStructureTargetVersion;
    private boolean forbidUnknownRoles;
    private Map<IAccessibleElement, PdfStructElem> connectedModelToStruct;
    private Map<PdfDictionary, IAccessibleElement> connectedStructToModel;

    public TagStructureContext(PdfDocument document) {
        this(document, document.getPdfVersion());
    }

    public TagStructureContext(PdfDocument document, PdfVersion tagStructureTargetVersion) {
        this.document = document;
        if (!document.isTagged()) {
            throw new PdfException("Must be a tagged document.");
        }
        this.connectedModelToStruct = new HashMap<IAccessibleElement, PdfStructElem>();
        this.connectedStructToModel = new HashMap<PdfDictionary, IAccessibleElement>();
        this.tagStructureTargetVersion = tagStructureTargetVersion;
        this.forbidUnknownRoles = true;
        this.normalizeDocumentRootTag();
    }

    public TagStructureContext setForbidUnknownRoles(boolean forbidUnknownRoles) {
        this.forbidUnknownRoles = forbidUnknownRoles;
        return this;
    }

    public PdfVersion getTagStructureTargetVersion() {
        return this.tagStructureTargetVersion;
    }

    public TagTreePointer getAutoTaggingPointer() {
        if (this.autoTaggingPointer == null) {
            this.autoTaggingPointer = new TagTreePointer(this.document);
        }
        return this.autoTaggingPointer;
    }

    public boolean isElementConnectedToTag(IAccessibleElement element) {
        return this.connectedModelToStruct.containsKey(element);
    }

    public TagStructureContext removeElementConnectionToTag(IAccessibleElement element) {
        PdfStructElem structElem = this.connectedModelToStruct.remove(element);
        this.removeStructToModelConnection(structElem);
        return this;
    }

    public TagTreePointer removeAnnotationTag(PdfAnnotation annotation) {
        PdfObjRef objRef;
        PdfStructElem structElem = null;
        PdfDictionary annotDic = (PdfDictionary)annotation.getPdfObject();
        PdfNumber structParentIndex = (PdfNumber)annotDic.get(PdfName.StructParent);
        if (structParentIndex != null && (objRef = this.document.getStructTreeRoot().findObjRefByStructParentIndex(annotDic.getAsDictionary(PdfName.P), structParentIndex.intValue())) != null) {
            PdfStructElem parent = (PdfStructElem)objRef.getParent();
            parent.removeKid(objRef);
            structElem = parent;
        }
        annotDic.remove(PdfName.StructParent);
        annotDic.setModified();
        if (structElem != null) {
            return new TagTreePointer(this.document).setCurrentStructElem(structElem);
        }
        return null;
    }

    public TagTreePointer removeContentItem(PdfPage page, int mcid) {
        PdfMcr mcr = this.document.getStructTreeRoot().findMcrByMcid((PdfDictionary)page.getPdfObject(), mcid);
        if (mcr == null) {
            return null;
        }
        PdfStructElem parent = (PdfStructElem)mcr.getParent();
        parent.removeKid(mcr);
        return new TagTreePointer(this.document).setCurrentStructElem(parent);
    }

    public TagStructureContext removePageTags(PdfPage page) {
        PdfStructTreeRoot structTreeRoot = this.document.getStructTreeRoot();
        Collection<PdfMcr> pageMcrs = structTreeRoot.getPageMarkedContentReferences(page);
        if (pageMcrs != null) {
            ArrayList<PdfMcr> mcrsList = new ArrayList<PdfMcr>(pageMcrs);
            for (PdfMcr mcr : mcrsList) {
                this.removePageTagFromParent(mcr, mcr.getParent());
            }
        }
        return this;
    }

    public TagStructureContext moveTagPointerToTag(IAccessibleElement element, TagTreePointer tagPointer) {
        PdfStructElem connectedStructElem = this.connectedModelToStruct.get(element);
        if (connectedStructElem == null) {
            throw new PdfException("Given accessible element is not connected to any tag.");
        }
        tagPointer.setCurrentStructElem(connectedStructElem);
        return this;
    }

    public TagStructureContext removeAllConnectionsToTags() {
        for (PdfStructElem structElem : this.connectedModelToStruct.values()) {
            this.removeStructToModelConnection(structElem);
        }
        this.connectedModelToStruct.clear();
        return this;
    }

    public TagStructureContext flushPageTags(PdfPage page) {
        PdfStructTreeRoot structTreeRoot = this.document.getStructTreeRoot();
        Collection<PdfMcr> pageMcrs = structTreeRoot.getPageMarkedContentReferences(page);
        if (pageMcrs != null) {
            for (PdfMcr mcr : pageMcrs) {
                PdfStructElem parent = (PdfStructElem)mcr.getParent();
                this.flushParentIfBelongsToPage(parent, page);
            }
        }
        return this;
    }

    public void normalizeDocumentRootTag() {
        boolean forbid = this.forbidUnknownRoles;
        this.forbidUnknownRoles = false;
        List<IPdfStructElem> rootKids = this.document.getStructTreeRoot().getKids();
        if (rootKids.size() == 1 && allowedRootTagRoles.contains(rootKids.get(0).getRole())) {
            this.rootTagElement = (PdfStructElem)rootKids.get(0);
        } else {
            PdfStructElem prevRootTag = this.rootTagElement;
            ((PdfDictionary)this.document.getStructTreeRoot().getPdfObject()).remove(PdfName.K);
            if (prevRootTag == null) {
                this.rootTagElement = this.document.getStructTreeRoot().addKid(new PdfStructElem(this.document, PdfName.Document));
            } else {
                this.document.getStructTreeRoot().addKid(this.rootTagElement);
                if (!PdfName.Document.equals(this.rootTagElement.getRole())) {
                    this.wrapAllKidsInTag(this.rootTagElement, this.rootTagElement.getRole());
                    this.rootTagElement.setRole(PdfName.Document);
                }
            }
            int originalRootKidsIndex = 0;
            boolean isBeforeOriginalRoot = true;
            for (IPdfStructElem elem : rootKids) {
                PdfStructElem kid = (PdfStructElem)elem;
                if (kid.getPdfObject() == this.rootTagElement.getPdfObject()) {
                    isBeforeOriginalRoot = false;
                    continue;
                }
                boolean kidIsDocument = PdfName.Document.equals(kid.getRole());
                if (isBeforeOriginalRoot) {
                    this.rootTagElement.addKid(originalRootKidsIndex, kid);
                    originalRootKidsIndex += kidIsDocument ? kid.getKids().size() : 1;
                } else {
                    this.rootTagElement.addKid(kid);
                }
                if (!kidIsDocument) continue;
                this.removeOldRoot(kid);
            }
        }
        this.forbidUnknownRoles = forbid;
    }

    public void actualizeTagsProperties() {
        for (Map.Entry<IAccessibleElement, PdfStructElem> structToModel : this.connectedModelToStruct.entrySet()) {
            IAccessibleElement element = structToModel.getKey();
            PdfStructElem structElem = structToModel.getValue();
            structElem.setRole(element.getRole());
            if (element.getAccessibilityProperties() == null) continue;
            element.getAccessibilityProperties().setToStructElem(structElem);
        }
    }

    public PdfStructElem getPointerStructElem(TagTreePointer pointer) {
        return pointer.getCurrentStructElem();
    }

    public TagTreePointer createPointerForStructElem(PdfStructElem structElem) {
        return new TagTreePointer(structElem);
    }

    PdfStructElem getRootTag() {
        return this.rootTagElement;
    }

    PdfDocument getDocument() {
        return this.document;
    }

    PdfStructElem getStructConnectedToModel(IAccessibleElement element) {
        return this.connectedModelToStruct.get(element);
    }

    IAccessibleElement getModelConnectedToStruct(PdfStructElem struct) {
        return this.connectedStructToModel.get(struct.getPdfObject());
    }

    void throwExceptionIfRoleIsInvalid(PdfName role) {
        if (this.forbidUnknownRoles && PdfStructElem.identifyType(this.getDocument(), role) == PdfStructElem.Unknown) {
            throw new PdfException("Role is not mapped with any standard role.");
        }
    }

    void saveConnectionBetweenStructAndModel(IAccessibleElement element, PdfStructElem structElem) {
        this.connectedModelToStruct.put(element, structElem);
        this.connectedStructToModel.put((PdfDictionary)structElem.getPdfObject(), element);
    }

    IPdfStructElem flushTag(PdfStructElem tagStruct) {
        IAccessibleElement modelElement = this.connectedStructToModel.remove(tagStruct.getPdfObject());
        if (modelElement != null) {
            this.connectedModelToStruct.remove(modelElement);
        }
        IPdfStructElem parent = tagStruct.getParent();
        this.flushStructElementAndItKids(tagStruct);
        return parent;
    }

    private void removeStructToModelConnection(PdfStructElem structElem) {
        if (structElem != null) {
            IAccessibleElement element = this.connectedStructToModel.remove(structElem.getPdfObject());
            structElem.setRole(element.getRole());
            if (element.getAccessibilityProperties() != null) {
                element.getAccessibilityProperties().setToStructElem(structElem);
            }
            if (structElem.getParent() == null) {
                this.flushStructElementAndItKids(structElem);
            }
        }
    }

    private void removePageTagFromParent(IPdfStructElem pageTag, IPdfStructElem parent) {
        if (parent instanceof PdfStructElem) {
            PdfStructElem structParent = (PdfStructElem)parent;
            if (!structParent.isFlushed()) {
                structParent.removeKid(pageTag);
                PdfDictionary parentObject = (PdfDictionary)structParent.getPdfObject();
                if (!this.connectedStructToModel.containsKey(parentObject) && parent.getKids().size() == 0 && parentObject != this.rootTagElement.getPdfObject()) {
                    this.removePageTagFromParent(structParent, parent.getParent());
                    parentObject.getIndirectReference().setFree();
                }
            } else if (pageTag instanceof PdfMcr) {
                throw new PdfException("Cannot remove tag, because its parent is flushed.");
            }
        }
    }

    private void flushParentIfBelongsToPage(PdfStructElem parent, PdfPage currentPage) {
        if (parent.isFlushed() || this.connectedStructToModel.containsKey(parent.getPdfObject()) || parent.getPdfObject() == this.rootTagElement.getPdfObject()) {
            return;
        }
        List<IPdfStructElem> kids = parent.getKids();
        boolean allKidsBelongToPage = true;
        for (IPdfStructElem kid : kids) {
            if (kid instanceof PdfMcr) {
                PdfDictionary kidPage = ((PdfMcr)kid).getPageObject();
                if (kidPage.isFlushed() || kidPage.equals(currentPage.getPdfObject())) continue;
                allKidsBelongToPage = false;
                break;
            }
            if (!(kid instanceof PdfStructElem)) continue;
            allKidsBelongToPage = false;
            break;
        }
        if (allKidsBelongToPage) {
            IPdfStructElem parentsParent = parent.getParent();
            parent.flush();
            if (parentsParent instanceof PdfStructElem) {
                this.flushParentIfBelongsToPage((PdfStructElem)parentsParent, currentPage);
            }
        }
    }

    private void flushStructElementAndItKids(PdfStructElem elem) {
        if (this.connectedStructToModel.containsKey(elem.getPdfObject())) {
            return;
        }
        for (IPdfStructElem kid : elem.getKids()) {
            if (!(kid instanceof PdfStructElem)) continue;
            this.flushStructElementAndItKids((PdfStructElem)kid);
        }
        elem.flush();
    }

    private void wrapAllKidsInTag(PdfStructElem parent, PdfName wrapTagRole) {
        int kidsNum = parent.getKids().size();
        TagTreePointer tagPointer = new TagTreePointer(this.document);
        tagPointer.setCurrentStructElem(parent).addTag(0, wrapTagRole);
        TagTreePointer newParentOfKids = new TagTreePointer(tagPointer);
        tagPointer.moveToParent();
        for (int i = 0; i < kidsNum; ++i) {
            tagPointer.relocateKid(1, newParentOfKids);
        }
    }

    private void removeOldRoot(PdfStructElem oldRoot) {
        TagTreePointer tagPointer = new TagTreePointer(this.document);
        tagPointer.setCurrentStructElem(oldRoot).removeTag();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.getClass().toString());
    }

    static {
        allowedRootTagRoles.add(PdfName.Book);
        allowedRootTagRoles.add(PdfName.Document);
        allowedRootTagRoles.add(PdfName.Part);
        allowedRootTagRoles.add(PdfName.Art);
        allowedRootTagRoles.add(PdfName.Sect);
        allowedRootTagRoles.add(PdfName.Div);
    }
}

