/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.MemoryLimitsAwareException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

class MemoryLimitsAwareOutputStream
extends ByteArrayOutputStream {
    private static final int DEFAULT_MAX_STREAM_SIZE = 0x7FFFFFF7;
    private int maxStreamSize = 0x7FFFFFF7;

    public MemoryLimitsAwareOutputStream() {
    }

    public MemoryLimitsAwareOutputStream(int size) {
        super(size);
    }

    public long getMaxStreamSize() {
        return this.maxStreamSize;
    }

    public MemoryLimitsAwareOutputStream setMaxStreamSize(int maxStreamSize) {
        this.maxStreamSize = maxStreamSize;
        return this;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        int minCapacity = this.count + len;
        if (minCapacity < 0) {
            throw new MemoryLimitsAwareException("During decompression a single stream occupied more than a maximum integer value. Please check your pdf.");
        }
        if (minCapacity > this.maxStreamSize) {
            throw new MemoryLimitsAwareException("During decompression a single stream occupied more memory than allowed. Please either check your pdf or increase the allowed multiple decompressed pdf streams maximum size value by setting the appropriate parameter of ReaderProperties's MemoryLimitsAwareHandler.");
        }
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 0 || newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - this.maxStreamSize > 0) {
            newCapacity = this.maxStreamSize;
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
        super.write(b, off, len);
    }
}

