/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.tagging.PdfStructTreeRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfNamespace
extends PdfObjectWrapper<PdfDictionary> {
    public PdfNamespace(PdfDictionary dictionary) {
        super(dictionary);
        this.setForbidRelease();
    }

    public PdfNamespace(String namespaceName) {
        this(new PdfString(namespaceName));
    }

    public PdfNamespace(PdfString namespaceName) {
        this(new PdfDictionary());
        this.put(PdfName.Type, PdfName.Namespace);
        this.put(PdfName.NS, namespaceName);
    }

    public PdfNamespace setNamespaceName(String namespaceName) {
        return this.setNamespaceName(new PdfString(namespaceName));
    }

    public PdfNamespace setNamespaceName(PdfString namespaceName) {
        return this.put(PdfName.NS, namespaceName);
    }

    public String getNamespaceName() {
        PdfString ns = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.NS);
        return ns != null ? ns.toUnicodeString() : null;
    }

    public PdfNamespace setSchema(PdfFileSpec fileSpec) {
        return this.put(PdfName.Schema, (PdfObject)fileSpec.getPdfObject());
    }

    public PdfFileSpec getSchema() {
        PdfObject schemaObject = ((PdfDictionary)this.getPdfObject()).get(PdfName.Schema);
        return PdfFileSpec.wrapFileSpecObject(schemaObject);
    }

    public PdfNamespace setNamespaceRoleMap(PdfDictionary roleMapNs) {
        return this.put(PdfName.RoleMapNS, roleMapNs);
    }

    public PdfDictionary getNamespaceRoleMap() {
        return this.getNamespaceRoleMap(false);
    }

    public PdfNamespace addNamespaceRoleMapping(String thisNsRole, String defaultNsRole) {
        PdfObject prevVal = this.getNamespaceRoleMap(true).put(PdfStructTreeRoot.convertRoleToPdfName(thisNsRole), PdfStructTreeRoot.convertRoleToPdfName(defaultNsRole));
        this.logOverwritingOfMappingIfNeeded(thisNsRole, prevVal);
        this.setModified();
        return this;
    }

    public PdfNamespace addNamespaceRoleMapping(String thisNsRole, String targetNsRole, PdfNamespace targetNs) {
        PdfArray targetMapping = new PdfArray();
        targetMapping.add(PdfStructTreeRoot.convertRoleToPdfName(targetNsRole));
        targetMapping.add((PdfObject)targetNs.getPdfObject());
        PdfObject prevVal = this.getNamespaceRoleMap(true).put(PdfStructTreeRoot.convertRoleToPdfName(thisNsRole), targetMapping);
        this.logOverwritingOfMappingIfNeeded(thisNsRole, prevVal);
        this.setModified();
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private PdfNamespace put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    private PdfDictionary getNamespaceRoleMap(boolean createIfNotExist) {
        PdfDictionary roleMapNs = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.RoleMapNS);
        if (createIfNotExist && roleMapNs == null) {
            roleMapNs = new PdfDictionary();
            this.put(PdfName.RoleMapNS, roleMapNs);
        }
        return roleMapNs;
    }

    private void logOverwritingOfMappingIfNeeded(String thisNsRole, PdfObject prevVal) {
        if (prevVal != null) {
            Logger logger = LoggerFactory.getLogger(PdfNamespace.class);
            String nsNameStr = this.getNamespaceName();
            if (nsNameStr == null) {
                nsNameStr = "this";
            }
            logger.warn(MessageFormatUtil.format((String)"Existing mapping for {0} in {1} namespace was overwritten.", (Object[])new Object[]{thisNsRole, nsNameStr}));
        }
    }
}

