/*
 * Decompiled with CFR 0.152.
 */
package com.jartifacts.shDao.impl;

import com.jartifacts.propertySet.PropertySet;
import com.jartifacts.shDao.SHDao;
import com.jartifacts.shDao.exceptions.DaoException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="SHDao")
public abstract class SHDaoImpl<T extends Serializable, KeyType extends Serializable>
extends HibernateDaoSupport
implements SHDao<T, KeyType> {
    private static final long serialVersionUID = 1L;
    private Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    @Transactional
    public void add(T entity) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.saveOrUpdate(entity);
        session.flush();
        session.evict(entity);
    }

    @Override
    public void set(T entity) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.update(entity);
        session.flush();
        session.evict(entity);
    }

    @Override
    public void del(T entity) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        session.delete(entity);
        session.flush();
        session.evict(entity);
    }

    @Override
    public void deleteAll() {
        Session session = this.getSessionFactory().getCurrentSession();
        String hqlDelete = "delete " + this.getEntityClass().getName();
        session.createQuery(hqlDelete).executeUpdate();
    }

    @Override
    public void deleteById(KeyType id) throws DaoException {
        T entity = this.get(id);
        this.del(entity);
    }

    @Override
    public int count() {
        Session session = this.getSessionFactory().getCurrentSession();
        Criteria criteria = session.createCriteria(this.getEntityClass());
        criteria.setProjection(Projections.rowCount());
        return (Integer)criteria.uniqueResult();
    }

    @Override
    public T get(KeyType id) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        return (T)((Serializable)session.get(this.getEntityClass(), id));
    }

    @Override
    public T getByCodigo(Object codigo) throws DaoException {
        return this.getUnique("codigo", codigo);
    }

    @Override
    public T getUnique(String campoUnique, Object valorUnique) throws DaoException {
        PropertySet propertySet = new PropertySet();
        propertySet.setProperty(campoUnique, valorUnique);
        List<PropertySet> list = this.getByQuery((T)propertySet);
        Serializable returnObject = null;
        if (list != null && list.size() > 0) {
            returnObject = (Serializable)list.get(0);
        }
        return (T)returnObject;
    }

    @Override
    public List<T> getAll() throws DaoException {
        return this.getAll(0, 0);
    }

    @Override
    public List<T> getByQuery(PropertySet propertySet) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        Criteria criteria = session.createCriteria(this.getEntityClass());
        if (propertySet != null) {
            for (String propertyName : propertySet.getProperties().keySet()) {
                Object value = propertySet.getProperty(propertyName);
                if (propertyName.contains("like:")) {
                    propertyName = propertyName.substring(5);
                    criteria.add((Criterion)Restrictions.like((String)propertyName, (Object)value));
                    continue;
                }
                if (propertyName.contains("first:")) {
                    criteria.setFirstResult(((Integer)value).intValue());
                    continue;
                }
                if (propertyName.contains("max:")) {
                    criteria.setMaxResults(((Integer)value).intValue());
                    continue;
                }
                criteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
            }
        }
        return criteria.list();
    }

    @Override
    public List<T> getByQuery(T entity) throws DaoException {
        return this.getByQuery(entity, 0, 0);
    }

    @Override
    public List<T> getByCriteria(Criterion ... criterion) {
        return this.getByCriteria(0, 0, criterion);
    }

    @Override
    public List<T> getAll(int firstRow, int maxResult) throws DaoException {
        Session session = this.getSessionFactory().getCurrentSession();
        Criteria criteria = session.createCriteria(this.getEntityClass());
        if (maxResult > 0) {
            criteria.setFirstResult(firstRow);
            criteria.setMaxResults(maxResult);
        }
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Override
    public List<T> getByQuery(PropertySet propertySet, int firstRow, int maxResult) throws DaoException {
        propertySet.setProperty("first:", (Object)firstRow);
        propertySet.setProperty("max:", (Object)maxResult);
        return this.getByQuery((T)propertySet);
    }

    @Override
    public List<T> getByQuery(T entity, int firstRow, int maxResult) throws DaoException {
        Criteria criteria = this.getSessionFactory().getCurrentSession().createCriteria(this.getEntityClass());
        Example hibExample = Example.create(entity);
        criteria.add((Criterion)hibExample);
        if (maxResult > 0) {
            criteria.setFirstResult(firstRow);
            criteria.setMaxResults(maxResult);
        }
        return criteria.list();
    }

    @Override
    public List<T> getByCriteria(int firstRow, int maxResult, Criterion ... criterion) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        Criterion[] criterionArray = criterion;
        int n = criterion.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        if (maxResult > 0) {
            criteria.setFirstResult(firstRow);
            criteria.setMaxResults(maxResult);
        }
        return criteria.list();
    }

    @Override
    public T getByQueryUnique(T entity) throws DaoException {
        Serializable value = null;
        List<T> entities = this.getByQuery(entity);
        if (entities.size() > 0) {
            value = (Serializable)entities.get(0);
        }
        return (T)value;
    }
}

