/*
 * Decompiled with CFR 0.152.
 */
package com.jartifacts.object;

import com.jartifacts.object.enums.ExceptionMessage;
import com.jartifacts.object.exception.ObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ObjectManager {
    public String getClassName(Object obj) {
        return obj.getClass().getName();
    }

    public <T> T invoke(Object object, String methodName, Object[] parameters) throws ObjectException {
        Object retObj;
        Method meth;
        Class<?> cls = object.getClass();
        Class[] parameterType = new Class[parameters.length];
        Integer index = 0;
        while (index < parameters.length) {
            parameterType[index.intValue()] = parameters[index].getClass();
            index = index + 1;
        }
        try {
            meth = cls.getMethod(methodName, parameterType);
        }
        catch (SecurityException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.SECURITY.getMessage()) + "(" + methodName + ")\r\n" + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.NO_SUCH_METHOD.getMessage()) + "(" + methodName + ")\r\n" + e.getMessage());
        }
        try {
            retObj = meth.invoke(object, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + methodName + "\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + methodName + "\r\n" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.INVOCATION_TARGET.getMessage()) + "(" + methodName + "\r\n" + e.getMessage());
        }
        return (T)retObj;
    }

    public <T> T invoke(Object object, String methodName) throws ObjectException {
        Object[] parameters = new Object[]{};
        return this.invoke(object, methodName, parameters);
    }

    public void set(Object object, String fieldName, Object value) throws ObjectException {
        Field field;
        Class<?> cls = object.getClass();
        try {
            field = cls.getDeclaredField(fieldName);
            if (Modifier.toString(field.getModifiers()).contains("static")) {
                throw new ObjectException(String.valueOf(ExceptionMessage.CANT_SET_ON_STATIC_FIELD.getMessage()) + "(" + fieldName + ")");
            }
        }
        catch (SecurityException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.SECURITY.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.NO_SUCH_FIELD.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        field.setAccessible(isAccesible);
    }

    public void set(Object object, Field field, Object value) throws ObjectException {
        if (Modifier.toString(field.getModifiers()).contains("static")) {
            throw new ObjectException(ExceptionMessage.CANT_SET_ON_STATIC_FIELD);
        }
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + field.getName() + ")\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + field.getName() + ")\r\n" + e.getMessage());
        }
        field.setAccessible(isAccesible);
    }

    public <T> T get(Object object, Field field) throws ObjectException {
        Object retObj;
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            retObj = field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + field.getName() + ")\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + field.getName() + ")\r\n" + e.getMessage());
        }
        field.setAccessible(isAccesible);
        return (T)retObj;
    }

    public <T> T get(Object object, String fieldName) throws ObjectException {
        Object retObj;
        Field field;
        Class<?> cls = object.getClass();
        try {
            field = cls.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.SECURITY.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.NO_SUCH_FIELD.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        boolean isAccesible = field.isAccessible();
        field.setAccessible(true);
        try {
            retObj = field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + fieldName + ")\r\n" + e.getMessage());
        }
        field.setAccessible(isAccesible);
        return (T)retObj;
    }

    public <T> T cloneObject(Object object) throws ObjectException {
        T returnObject = this.createObject(object.getClass().getName());
        Field[] field = object.getClass().getDeclaredFields();
        Integer index = 0;
        while (index < field.length) {
            this.set(returnObject, field[index], this.get(object, field[index]));
            index = index + 1;
        }
        return returnObject;
    }

    public <T> T cloneObject(Object object, Field[] field) throws ObjectException {
        T returnObject = this.createObject(object.getClass().getName());
        Integer index = 0;
        while (index < field.length) {
            this.set(returnObject, field[index], this.get(object, field[index]));
            index = index + 1;
        }
        return returnObject;
    }

    public Field[] getDeclaredFieldsWithInheritance(Object object) {
        ArrayList<Field> fieldToReturn = new ArrayList<Field>();
        Class<?> cls = object.getClass();
        while (cls != null) {
            Field[] fieldList = cls.getDeclaredFields();
            int index = 0;
            while (index < fieldList.length) {
                fieldToReturn.add(fieldList[index]);
                ++index;
            }
            cls = cls.getSuperclass();
        }
        Field[] fieldArray = new Field[fieldToReturn.size()];
        return fieldToReturn.toArray(fieldArray);
    }

    public List<Method> getMeothdWithAnnotation(Object object, Class annotation) {
        ArrayList<Method> methodWithAnnotation = new ArrayList<Method>();
        Class<?> cls = object.getClass();
        Method[] methodList = cls.getDeclaredMethods();
        int index = 0;
        while (index < methodList.length) {
            Object annotationMethod = methodList[index].getAnnotation(annotation);
            if (annotationMethod != null) {
                methodWithAnnotation.add(methodList[index]);
            }
            ++index;
        }
        return methodWithAnnotation;
    }

    public <T> T createObject(String className) throws ObjectException {
        Object[] parameters = new Object[]{};
        return this.createObject(className, parameters);
    }

    public <T> T createObject(String className, Object[] parameters) throws ObjectException {
        try {
            Class<?> cls = Class.forName(className);
            Class[] partypes = new Class[parameters.length];
            Object[] arglist = new Object[parameters.length];
            Integer index = 0;
            while (index < parameters.length) {
                Object obj = parameters[index];
                partypes[index.intValue()] = obj.getClass();
                arglist[index.intValue()] = obj;
                index = index + 1;
            }
            Constructor<?> ct = cls.getConstructor(partypes);
            return (T)ct.newInstance(arglist);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ARGUMENT.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.ILLEGAL_ACCCES.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.CLASS_NOT_FOUND.getMessage()) + "(" + className + ")(" + className + ")\r\n" + e.getMessage());
        }
        catch (SecurityException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.SECURITY.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.NO_SUCH_METHOD.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.INITIATION.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ObjectException(String.valueOf(ExceptionMessage.INVOCATION_TARGET.getMessage()) + "(" + className + ")\r\n" + e.getMessage());
        }
    }
}

