/*
 * Decompiled with CFR 0.152.
 */
package com.jartifacts.propertyManager;

import com.jartifacts.propertyManager.exceptions.FilePropertyNotFoundException;
import com.jartifacts.propertyManager.exceptions.PropertyNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;

public class PropertyManager {
    private boolean loadedProperties = false;
    private Properties properties = null;
    private StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
    private String fileName;
    private String password = "pepepepe";
    private boolean notAsResource = false;

    public boolean isNotAsResource() {
        return this.notAsResource;
    }

    public void setNotAsResource(boolean notAsResource) {
        this.notAsResource = notAsResource;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.loadedProperties = false;
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    private void load() throws FilePropertyNotFoundException {
        if (this.loadedProperties) {
            return;
        }
        this.encryptor.setPassword(this.password);
        this.properties = new EncryptableProperties((StringEncryptor)this.encryptor);
        try {
            if (this.notAsResource) {
                FileInputStream in = new FileInputStream(new File(this.fileName));
                this.properties.load(in);
            } else {
                this.properties.load(this.properties.getClass().getResourceAsStream("/" + this.fileName));
            }
        }
        catch (IOException e) {
            throw new FilePropertyNotFoundException(this.fileName);
        }
        this.loadedProperties = true;
    }

    public String getProperty(String propertyName) throws PropertyNotFoundException, FilePropertyNotFoundException {
        String property = null;
        this.load();
        property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new PropertyNotFoundException(propertyName);
        }
        return property;
    }

    public void setProperty(String propiedad, String valor) throws FilePropertyNotFoundException {
        this.load();
        this.properties.setProperty(propiedad, valor);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() throws FilePropertyNotFoundException {
        this.load();
        return this.properties;
    }
}

