/*
 * Decompiled with CFR 0.152.
 */
package com.jartifacts.spring;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class SpringExtension0
implements ApplicationContextAware {
    private static ApplicationContext context = null;
    private static String resourceFile = "applicationContext.xml";

    private SpringExtension0() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(String beanName) {
        Object obj = null;
        try {
            obj = context.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return (T)obj;
    }

    public static <T> T getBeanOrNull(String beanName) {
        Object obj = null;
        if (context.containsBeanDefinition(beanName)) {
            obj = context.getBean(beanName);
        }
        return (T)obj;
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static void loadContext() {
        try {
            if (context == null) {
                context = new ClassPathXmlApplicationContext("classpath:" + resourceFile);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void setResourceFile(String xmlFile) {
        resourceFile = xmlFile;
    }

    public static String getResourceFile() {
        return resourceFile;
    }
}

