/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.lob;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.lob.LobChunk;
import com.kubling.teiid.client.lob.LobChunkProducer;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.jdbc.JDBCPlugin;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamingLobChunckProducer
implements LobChunkProducer {
    private static AtomicInteger REQUEST_SEQUENCE = new AtomicInteger(0);
    private final Streamable<?> streamable;
    private final DQP dqp;
    private final long requestId;
    private final int streamRequestId = REQUEST_SEQUENCE.getAndIncrement();

    public StreamingLobChunckProducer(DQP dqp, long requestId, Streamable<?> streamable) {
        this.dqp = dqp;
        this.requestId = requestId;
        this.streamable = streamable;
    }

    @Override
    public LobChunk getNextChunk() throws IOException {
        try {
            ResultsFuture<LobChunk> result = this.dqp.requestNextLobChunk(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
            return (LobChunk)result.get();
        }
        catch (Exception e) {
            IOException ex = new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", new Object[]{e.getMessage()}), e);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.dqp.closeLobChunkStream(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
        }
        catch (TeiidException e) {
            IOException ex = new IOException(e.getMessage(), e);
            throw ex;
        }
    }

    public static class Factory {
        private final Streamable<?> streamable;
        private final DQP dqp;
        private final long requestId;

        public Factory(DQP dqp, long requestId, Streamable<?> streamable) {
            this.dqp = dqp;
            this.requestId = requestId;
            this.streamable = streamable;
        }

        public StreamingLobChunckProducer getLobChunkProducer() {
            return new StreamingLobChunckProducer(this.dqp, this.requestId, this.streamable);
        }
    }
}

