/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.plan;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.core.util.ExternalizeUtil;
import com.kubling.teiid.jdbc.JDBCPlugin;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PlanNode
implements Externalizable {
    private LinkedHashMap<String, Property> properties = new LinkedHashMap();
    private PlanNode parent;
    private String name;

    public PlanNode() {
    }

    public PlanNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setParent(PlanNode parent) {
        this.parent = parent;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.properties.values());
    }

    public void addProperty(String pname, PlanNode value) {
        Property p = new Property(pname);
        p.setPlanNode(value);
        value.setParent(this);
        this.properties.put(pname, p);
    }

    public void addProperty(String pname, List<String> value) {
        Property p = new Property(pname);
        if (value == null) {
            value = Collections.emptyList();
        }
        p.setValues(value);
        this.properties.put(pname, p);
    }

    public void addProperty(String pname, String value) {
        Property p = new Property(pname);
        if (value == null) {
            p.setValues(new ArrayList<String>(0));
        } else {
            p.setValues(Arrays.asList(value));
        }
        this.properties.put(pname, p);
    }

    public String toXml() {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            StringWriter stringWriter = new StringWriter();
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(stringWriter);
            writer.writeStartDocument("UTF-8", "1.0");
            this.writePlanNode(this, writer);
            writer.writeEndDocument();
            return stringWriter.toString();
        }
        catch (FactoryConfigurationError e) {
            throw new TeiidRuntimeException((BundleUtil.Event)JDBCPlugin.Event.TEIID20002, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)JDBCPlugin.Event.TEIID20003, (Throwable)e);
        }
    }

    private void writeProperty(Property property, XMLStreamWriter writer) throws XMLStreamException {
        PlanNode node;
        writer.writeStartElement("property");
        writer.writeAttribute("name", property.getName());
        if (property.getValues() != null) {
            for (String value : property.getValues()) {
                if (value == null) continue;
                PlanNode.writeElement(writer, "value", value);
            }
        }
        if ((node = property.getPlanNode()) != null) {
            this.writePlanNode(node, writer);
        }
        writer.writeEndElement();
    }

    private void writePlanNode(PlanNode node, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("node");
        writer.writeAttribute("name", node.getName());
        for (Property p : node.getProperties()) {
            this.writeProperty(p, writer);
        }
        writer.writeEndElement();
    }

    private static void writeElement(XMLStreamWriter writer, String name, String value) throws XMLStreamException {
        writer.writeStartElement(name);
        if (value != null) {
            writer.writeCharacters(value);
        }
        writer.writeEndElement();
    }

    private static Properties getAttributes(XMLStreamReader reader) {
        Properties props = new Properties();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                props.setProperty(attrName, attrValue);
            }
        }
        return props;
    }

    public static PlanNode fromXml(String planString) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(new StringReader(planString));
        if (reader.hasNext() && reader.nextTag() != 2) {
            String element = reader.getLocalName();
            if (element.equals("node")) {
                Properties props = PlanNode.getAttributes(reader);
                PlanNode planNode = new PlanNode(props.getProperty("name"));
                planNode.setParent(null);
                PlanNode.buildNode(reader, planNode);
                return planNode;
            }
            throw new XMLStreamException(JDBCPlugin.Util.gs("unexpected_element", new Object[]{reader.getName(), "node"}), reader.getLocation());
        }
        return null;
    }

    private static PlanNode buildNode(XMLStreamReader reader, PlanNode node) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String property = reader.getLocalName();
            if (property.equals("property")) {
                Properties props = PlanNode.getAttributes(reader);
                ArrayList<String> values = new ArrayList<String>();
                while (reader.hasNext() && reader.nextTag() != 2) {
                    String valueNode = reader.getLocalName();
                    if (values != null && valueNode.equals("value")) {
                        values.add(reader.getElementText());
                        continue;
                    }
                    if (valueNode.equals("node")) {
                        values = null;
                        Properties nodeProps = PlanNode.getAttributes(reader);
                        PlanNode childNode = new PlanNode(nodeProps.getProperty("name"));
                        node.addProperty(props.getProperty("name"), PlanNode.buildNode(reader, childNode));
                        continue;
                    }
                    throw new XMLStreamException(JDBCPlugin.Util.gs("unexpected_element", new Object[]{reader.getName(), "value"}), reader.getLocation());
                }
                if (values == null) continue;
                node.addProperty(props.getProperty("name"), values);
                continue;
            }
            throw new XMLStreamException(JDBCPlugin.Util.gs("unexpected_element", new Object[]{reader.getName(), "property"}), reader.getLocation());
        }
        return node;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.visitNode(this, 0, false, builder);
        return builder.toString();
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder();
        this.visitNode(this, 0, true, builder);
        return builder.toString();
    }

    protected void visitNode(PlanNode node, int nodeLevel, boolean yaml, StringBuilder text) {
        text.append("  ".repeat(Math.max(0, nodeLevel)));
        text.append(node.getName());
        if (yaml) {
            text.append(":\n");
        } else {
            text.append("\n");
        }
        int propTabs = nodeLevel + 1;
        for (Property property : node.getProperties()) {
            text.append("  ".repeat(Math.max(0, propTabs)));
            this.printProperty(nodeLevel, property, yaml, text);
        }
    }

    private void printProperty(int nodeLevel, Property p, boolean yaml, StringBuilder text) {
        if (!yaml) {
            text.append("+ ");
        }
        text.append(p.getName());
        if (p.getPlanNode() != null) {
            text.append(":\n");
            this.visitNode(p.getPlanNode(), nodeLevel + 2, yaml, text);
        } else if (p.getValues().size() > 1) {
            text.append(":\n");
            for (int i = 0; i < p.getValues().size(); ++i) {
                text.append("  ".repeat(Math.max(0, nodeLevel + 2)));
                if (yaml) {
                    text.append("- ");
                } else {
                    text.append(i);
                    text.append(": ");
                }
                text.append(p.getValues().get(i));
                text.append("\n");
            }
        } else if (p.getValues().size() == 1) {
            if (yaml) {
                text.append(": ");
            } else {
                text.append(":");
            }
            text.append(p.getValues().getFirst());
            text.append("\n");
        } else if (yaml) {
            text.append(": ~\n");
        } else {
            text.append("\n");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = new LinkedHashMap();
        for (Property p : ExternalizeUtil.readList((ObjectInput)in, Property.class)) {
            this.properties.put(p.name, p);
        }
        this.parent = (PlanNode)in.readObject();
        this.name = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeCollection((ObjectOutput)out, this.properties.values());
        out.writeObject(this.parent);
        out.writeObject(this.name);
    }

    public Property getProperty(String pName) {
        return this.properties.get(pName);
    }

    public static class Property
    implements Externalizable {
        private String name;
        private List<String> values;
        private PlanNode planNode;

        public Property() {
        }

        public Property(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public PlanNode getPlanNode() {
            return this.planNode;
        }

        public void setPlanNode(PlanNode planNode) {
            this.planNode = planNode;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.values = ExternalizeUtil.readList((ObjectInput)in, String.class);
            this.planNode = (PlanNode)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.name);
            ExternalizeUtil.writeCollection((ObjectOutput)out, this.values);
            out.writeObject(this.planNode);
        }
    }
}

