/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.core.types.BinaryType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.util.ReaderInputStream;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.TeiidSQLException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    static BigDecimal getBigDecimal(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, BigDecimal.class);
    }

    static <T> T transform(Object value, Class<T> targetType) throws SQLException {
        return DataTypeTransformer.transform(value, targetType, DataTypeTransformer.getRuntimeType(targetType));
    }

    static <T> T transform(Object value, Class<T> targetType, Class<?> runtimeType) throws SQLException {
        if (value == null || targetType.isAssignableFrom(value.getClass())) {
            return targetType.cast(value);
        }
        if (targetType == byte[].class) {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Blob.class, String.class, BinaryType.class}, (Object)object2, n)) {
                case 0: {
                    Blob blob = (Blob)object2;
                    long length = blob.length();
                    if (length > Integer.MAX_VALUE) {
                        throw new TeiidSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.blob_too_big"));
                    }
                    return targetType.cast(blob.getBytes(1L, (int)length));
                }
                case 1: {
                    String s = (String)object2;
                    return targetType.cast(s.getBytes());
                }
                case 2: {
                    BinaryType binaryType = (BinaryType)object2;
                    return targetType.cast(binaryType.getBytesDirect());
                }
            }
        } else if (targetType == String.class) {
            if (value instanceof SQLXML) {
                return targetType.cast(((SQLXML)value).getString());
            }
            if (value instanceof Clob) {
                Clob c = (Clob)value;
                long length = c.length();
                if (length == 0L) {
                    return targetType.cast("");
                }
                return targetType.cast(c.getSubString(1L, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length));
            }
        }
        try {
            return (T)DataTypeManager.transformValue((Object)DataTypeManager.convertToRuntimeType((Object)value, (boolean)true), runtimeType);
        }
        catch (Exception e) {
            Object valueStr = value.toString();
            if (((String)valueStr).length() > 20) {
                valueStr = ((String)valueStr).substring(0, 20) + "...";
            }
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting", new Object[]{valueStr, targetType.getSimpleName()});
            throw TeiidSQLException.create(e, msg);
        }
    }

    static <T> Class<?> getRuntimeType(Class<T> type) {
        Class runtimeType = type;
        if (!DataTypeManager.getAllDataTypeClasses().contains(type)) {
            runtimeType = type == Clob.class ? DataTypeManager.DefaultDataClasses.CLOB : (type == Blob.class ? DataTypeManager.DefaultDataClasses.BLOB : (type == SQLXML.class ? DataTypeManager.DefaultDataClasses.XML : (type == byte[].class ? DataTypeManager.DefaultDataClasses.VARBINARY : DataTypeManager.DefaultDataClasses.OBJECT)));
        }
        return runtimeType;
    }

    static boolean getBoolean(Object value) throws SQLException {
        if (value == null) {
            return false;
        }
        return DataTypeTransformer.transform(value, Boolean.class);
    }

    static byte getByte(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Byte.class);
    }

    static byte[] getBytes(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, byte[].class);
    }

    static Character getCharacter(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Character.class);
    }

    static Date getDate(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Date.class);
    }

    static double getDouble(Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        return DataTypeTransformer.transform(value, Double.class);
    }

    static float getFloat(Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        return DataTypeTransformer.transform(value, Float.class).floatValue();
    }

    static int getInteger(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Integer.class);
    }

    static long getLong(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return DataTypeTransformer.transform(value, Long.class);
    }

    static short getShort(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Short.class);
    }

    static Time getTime(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Time.class);
    }

    static Timestamp getTimestamp(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Timestamp.class);
    }

    static String getString(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, String.class);
    }

    static Blob getBlob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Blob.class);
    }

    static Clob getClob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Clob.class);
    }

    static SQLXML getSQLXML(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, SQLXML.class);
    }

    static Reader getCharacterStream(Object value) throws SQLException {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Clob.class, SQLXML.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Clob clob = (Clob)object;
                yield clob.getCharacterStream();
            }
            case 1 -> {
                SQLXML sqlxml = (SQLXML)object;
                yield sqlxml.getCharacterStream();
            }
            default -> new StringReader(DataTypeTransformer.getString(value));
        };
    }

    static InputStream getAsciiStream(Object value) throws SQLException {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Clob.class, SQLXML.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Clob clob = (Clob)object;
                yield clob.getAsciiStream();
            }
            case 1 -> {
                SQLXML sqlxml = (SQLXML)object;
                yield new ReaderInputStream(sqlxml.getCharacterStream(), StandardCharsets.US_ASCII);
            }
            default -> new ByteArrayInputStream(DataTypeTransformer.getString(value).getBytes(StandardCharsets.US_ASCII));
        };
    }

    static NClob getNClob(Object value) throws SQLException {
        Clob clob = DataTypeTransformer.getClob(value);
        if (clob == null) {
            return null;
        }
        if (clob instanceof NClob) {
            return (NClob)clob;
        }
        return (NClob)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NClob.class}, (proxy, method, args) -> {
            try {
                return method.invoke((Object)clob, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    static Array getArray(Object obj) throws SQLException {
        return DataTypeTransformer.transform(obj, Array.class, Object[].class);
    }
}

