/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.jdbc.ContinuousStatementCallback;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.jdbc.StatementCallback;
import com.kubling.teiid.jdbc.StatementImpl;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonBlockingRowProcessor
implements ResultsFuture.CompletionListener<Boolean> {
    private static final Logger logger = Logger.getLogger(NonBlockingRowProcessor.class.getName());
    private final StatementImpl stmt;
    private final StatementCallback callback;

    public NonBlockingRowProcessor(StatementImpl stmt, StatementCallback callback) {
        this.stmt = stmt;
        this.callback = callback;
    }

    @Override
    public void onCompletion(ResultsFuture<Boolean> future) {
        try {
            boolean hasResultSet = future.get();
            if (!hasResultSet) {
                this.callback.onComplete(this.stmt);
                return;
            }
            final ResultSetImpl resultSet = this.stmt.getResultSet();
            resultSet.asynch = true;
            Runnable rowProcessor = new Runnable(){
                final /* synthetic */ NonBlockingRowProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ResultsFuture<Boolean> hasNext;
                        do {
                            if (this.this$0.stmt.isClosed()) {
                                this.this$0.callback.onComplete(this.this$0.stmt);
                                break;
                            }
                            ResultsFuture<Boolean> resultsFuture = hasNext = resultSet.submitNext();
                            synchronized (resultsFuture) {
                                if (!hasNext.isDone()) {
                                    hasNext.addCompletionListener(f -> {
                                        if (this.this$0.processRow(f)) {
                                            this.run();
                                        }
                                    });
                                    break;
                                }
                            }
                        } while (this.this$0.processRow(hasNext));
                    }
                    catch (Exception e) {
                        this.this$0.onException(e);
                    }
                }
            };
            rowProcessor.run();
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    boolean processRow(ResultsFuture<Boolean> hasNext) {
        try {
            if (!hasNext.get().booleanValue()) {
                this.callback.onComplete(this.stmt);
                return false;
            }
            List<?> row = this.stmt.getResultSet().getCurrentRecord();
            if (row == null) {
                if (this.callback instanceof ContinuousStatementCallback) {
                    ((ContinuousStatementCallback)this.callback).beforeNextExecution(this.stmt);
                }
                return true;
            }
            this.callback.onRow(this.stmt, this.stmt.getResultSet());
            return true;
        }
        catch (Exception e) {
            this.onException(e);
            return false;
        }
        catch (Throwable t) {
            this.onException((Exception)new TeiidRuntimeException(t));
            return false;
        }
    }

    private void onException(Exception e) {
        ExecutionException ee;
        if (e instanceof ExecutionException && (ee = (ExecutionException)e).getCause() instanceof Exception) {
            e = (Exception)ee.getCause();
        }
        try {
            this.callback.onException(this.stmt, e);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Unhandled exception from StatementCallback", e);
        }
    }
}

