/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.SourceWarning;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.PartialResultsWarning;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.jdbc.TeiidSQLWarning;
import java.sql.SQLWarning;
import java.util.List;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        String sourceName = null;
        String modelName = null;
        if (ex instanceof SourceWarning) {
            SourceWarning exception = (SourceWarning)((Object)ex);
            if (exception.isPartialResultsError()) {
                PartialResultsWarning warning = new PartialResultsWarning(JDBCPlugin.Util.getString("WarningUtil.Failures_occurred"));
                warning.addConnectorFailure(exception.getConnectorBindingName(), TeiidSQLException.create((Throwable)((Object)exception)));
                return warning;
            }
            ex = exception.getCause();
            sourceName = exception.getConnectorBindingName();
            modelName = exception.getModelName();
        }
        String code = null;
        if (ex instanceof TeiidException) {
            code = ((TeiidException)ex).getCode();
        }
        return new TeiidSQLWarning(ex.getMessage(), code, ex, sourceName, modelName);
    }

    static SQLWarning convertWarnings(List<Throwable> exceptions) {
        SQLWarning root;
        if (exceptions == null || exceptions.isEmpty()) {
            return null;
        }
        SQLWarning current = root = WarningUtil.createWarning(exceptions.getFirst());
        for (int i = 1; i < exceptions.size(); ++i) {
            SQLWarning newWarning = WarningUtil.createWarning(exceptions.get(i));
            current.setNextWarning(newWarning);
            current = newWarning;
        }
        return root;
    }
}

