/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.core.util.ExecutorUtils;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultHostnameResolver {
    private final ConcurrentHashMap<String, Future<String>> resolved = new ConcurrentHashMap();
    private final ExecutorService executor = ExecutorUtils.newFixedThreadPool((int)1, (String)"resolver");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(InetAddress addr, int timeoutMillis) {
        if (addr.isLoopbackAddress()) {
            return addr.getCanonicalHostName();
        }
        String hostAddress = addr.getHostAddress();
        Future<String> hostName = this.resolved.get(hostAddress);
        if (hostName == null) {
            DefaultHostnameResolver defaultHostnameResolver = this;
            synchronized (defaultHostnameResolver) {
                hostName = this.resolved.get(hostAddress);
                if (hostName == null) {
                    hostName = this.executor.submit(new Resolver(addr));
                    this.resolved.put(hostAddress, hostName);
                }
            }
        }
        try {
            return hostName.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        catch (ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return null;
    }

    private static class Resolver
    implements Callable<String> {
        private InetAddress addr;

        private Resolver(InetAddress addr) {
            this.addr = addr;
        }

        @Override
        public String call() {
            String hostName = this.addr.getCanonicalHostName();
            this.addr = null;
            return hostName;
        }
    }
}

