/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.core.util.FilesystemHelper;
import com.kubling.teiid.core.util.PropertiesUtils;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.net.CommunicationException;
import com.kubling.teiid.net.ConnectionException;
import com.kubling.teiid.net.HostInfo;
import com.kubling.teiid.net.ServerConnectionFactory;
import com.kubling.teiid.net.TeiidURL;
import com.kubling.teiid.net.socket.DefaultHostnameResolver;
import com.kubling.teiid.net.socket.ObjectChannelFactory;
import com.kubling.teiid.net.socket.OioOjbectChannelFactory;
import com.kubling.teiid.net.socket.SocketServerConnection;
import com.kubling.teiid.net.socket.SocketServerInstance;
import com.kubling.teiid.net.socket.SocketServerInstanceFactory;
import com.kubling.teiid.net.socket.SocketServerInstanceImpl;
import com.kubling.teiid.net.socket.UrlServerDiscovery;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class SocketServerConnectionFactory
implements ServerConnectionFactory,
SocketServerInstanceFactory {
    private static final Logger log = Logger.getLogger("org.teiid.net.sockets");
    static final String PROPERTIES_FILENAME = "connectionPropsFilePath";
    static final String BACK_COMPAT_PROPERTIES_FILENAME = "org.teiid.client.properties.file";
    private static SocketServerConnectionFactory INSTANCE;
    private ObjectChannelFactory channelFactory;
    private final DefaultHostnameResolver resolver = new DefaultHostnameResolver();
    private long synchronousTtl = 240000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SocketServerConnectionFactory getInstance(Properties props) {
        if (INSTANCE == null) {
            INSTANCE = new SocketServerConnectionFactory();
            InputStream is = SocketServerConnectionFactory.getConnectionClientSettings((String)ObjectUtils.firstNonNull((Object[])new String[]{props.getProperty(PROPERTIES_FILENAME), props.getProperty(BACK_COMPAT_PROPERTIES_FILENAME), ""}));
            if (is != null) {
                Properties newProps = new Properties();
                try {
                    newProps.load(is);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                newProps.putAll((Map<?, ?>)props);
                props = newProps;
            }
            INSTANCE.initialize(props);
        }
        return INSTANCE;
    }

    public void initialize(Properties info) {
        PropertiesUtils.setBeanProperties((Object)this, (Properties)info, (String)"org.teiid.sockets", (boolean)true);
        this.channelFactory = new OioOjbectChannelFactory(info);
    }

    @Override
    public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, this.getSynchronousTtl(), this.channelFactory.getSoTimeout());
        ssii.connect(this.channelFactory);
        return ssii;
    }

    @Override
    public SocketServerConnection getConnection(Properties connectionProperties) throws CommunicationException, ConnectionException {
        TeiidURL url;
        try {
            url = new TeiidURL(connectionProperties.getProperty("serverURL"));
        }
        catch (MalformedURLException e1) {
            throw new ConnectionException(JDBCPlugin.Event.TEIID20014, e1, e1.getMessage());
        }
        UrlServerDiscovery discovery = new UrlServerDiscovery();
        discovery.init(url, connectionProperties);
        return new SocketServerConnection(this, url.isUsingSSL(), discovery, connectionProperties);
    }

    public long getSynchronousTtl() {
        return this.synchronousTtl;
    }

    public void setSynchronousTtl(long synchronousTTL) {
        this.synchronousTtl = synchronousTTL;
    }

    @Override
    public String resolveHostname(InetAddress addr) {
        return this.resolver.resolve(addr, 100);
    }

    private static InputStream getConnectionClientSettings(String location) {
        InputStream is = SocketServerConnectionFactory.class.getResourceAsStream(location = (String)StringUtils.defaultIfEmpty((CharSequence)location, (CharSequence)"/teiid-client-settings.properties"));
        if (Objects.nonNull(is)) {
            return is;
        }
        try {
            FileObject fo = FilesystemHelper.getManager().resolveFile(location);
            if (fo.exists()) {
                return fo.getContent().getInputStream();
            }
            log.warning(JDBCPlugin.Util.getString("SocketServerConnectionFactory.invalid_config_file", new Object[]{location}));
            return null;
        }
        catch (FileSystemException e) {
            log.severe(ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }
}

