/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.netty.handler.codec.serialization;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.util.ObjectInputStreamWithClassloader;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompactObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    CompactObjectInputStream(InputStream in) throws IOException {
        this(in, null);
    }

    public CompactObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    @Override
    protected void readStreamHeader() throws IOException {
        int version = this.readByte() & 0xFF;
        if (version != 5) {
            throw new StreamCorruptedException("Unsupported version: " + version);
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int type = this.read();
        if (type < 0) {
            throw new EOFException();
        }
        switch (type) {
            case 0: {
                return super.readClassDescriptor();
            }
            case 1: {
                String className = this.readUTF();
                Class<?> clazz = this.classLoader == null ? Class.forName(className, true, CompactObjectInputStream.class.getClassLoader()) : Class.forName(className, true, this.classLoader);
                return ObjectStreamClass.lookupAny(clazz);
            }
        }
        Class<?> clazz = CompactObjectOutputStream.KNOWN_CODES.get(type);
        if (clazz != null) {
            return ObjectStreamClass.lookupAny(clazz);
        }
        throw new StreamCorruptedException("Unexpected class descriptor type: " + type);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            ObjectInputStreamWithClassloader.checkClass((String)name);
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("com.kubling").log(Level.SEVERE, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20037, new Object[]{name}));
            throw e;
        }
        try {
            return Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }
}

