/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.netty.handler.codec.serialization;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.util.AccessibleBufferedInputStream;
import com.kubling.teiid.core.util.ExternalizeUtil;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.netty.handler.codec.serialization.CompactObjectInputStream;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.List;

public class ObjectDecoderInputStream
extends ObjectInputStream {
    private final AccessibleBufferedInputStream in;
    private final DataInput dis;
    private final ClassLoader classLoader;
    private final int maxObjectSize;
    private int remaining;
    private boolean foundLength;
    private final InputStream subStream = new InputStream(){

        @Override
        public int read() throws IOException {
            if (ObjectDecoderInputStream.this.remaining-- > 0) {
                return ObjectDecoderInputStream.this.in.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (ObjectDecoderInputStream.this.remaining <= 0) {
                return -1;
            }
            int read = ObjectDecoderInputStream.this.in.read(b, off, Math.min(len, ObjectDecoderInputStream.this.remaining));
            if (read > 0) {
                ObjectDecoderInputStream.this.remaining -= read;
            }
            return read;
        }
    };
    private Object result;
    private int streamIndex;
    private OutputStream stream;
    private List<InputStreamFactory.StreamFactoryReference> streams;

    public ObjectDecoderInputStream(AccessibleBufferedInputStream in, ClassLoader classLoader, int maxObjectSize) throws SecurityException, IOException {
        this.in = in;
        this.dis = new DataInputStream((InputStream)in);
        this.classLoader = classLoader;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        if (this.result == null) {
            if (!this.foundLength) {
                this.clearRemaining();
                this.remaining = this.dis.readInt();
                this.foundLength = true;
                if (this.remaining <= 0) {
                    throw new StreamCorruptedException("invalid data length: " + this.remaining);
                }
                if (this.remaining > this.maxObjectSize) {
                    throw new StreamCorruptedException(JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20028, new Object[]{this.remaining, this.maxObjectSize}));
                }
            }
            this.foundLength = false;
            CompactObjectInputStream cois = new CompactObjectInputStream(this.subStream, this.classLoader);
            this.result = cois.readObject();
            this.streams = ExternalizeUtil.readList((ObjectInput)cois, InputStreamFactory.StreamFactoryReference.class);
            this.streamIndex = 0;
        }
        while (this.streamIndex < this.streams.size()) {
            if (!this.foundLength) {
                this.clearRemaining();
                this.remaining = 0xFFFF & this.dis.readShort();
                this.foundLength = true;
                if (this.remaining < 0) {
                    throw new StreamCorruptedException("Invalid stream chunk length");
                }
            }
            if (this.stream == null) {
                final File f = File.createTempFile("teiid", null);
                InputStreamFactory.StreamFactoryReference sfr = this.streams.get(this.streamIndex);
                sfr.setStreamFactory(new InputStreamFactory(this){

                    public InputStream getInputStream() throws IOException {
                        return new BufferedInputStream(new FileInputStream(f));
                    }
                });
                this.stream = new FileOutputStream(f);
            }
            this.foundLength = false;
            if (this.remaining != 0) {
                int available = Math.min(this.remaining, this.in.getCount() - this.in.getPosition());
                if (available > 0) {
                    this.stream.write(this.in.getBuffer(), this.in.getPosition(), available);
                    this.in.setPosition(this.in.getPosition() + available);
                    this.remaining -= available;
                }
                if (this.remaining <= 0) continue;
                ObjectConverterUtil.write((OutputStream)this.stream, (InputStream)this.in, (byte[])this.in.getBuffer(), (int)this.remaining, (boolean)false);
                this.remaining = 0;
                continue;
            }
            this.stream.close();
            this.stream = null;
            ++this.streamIndex;
        }
        Object toReturn = this.result;
        this.result = null;
        this.streams = null;
        this.stream = null;
        return toReturn;
    }

    void clearRemaining() throws IOException {
        long skipped;
        while (this.remaining > 0 && (skipped = this.in.skip((long)this.remaining)) != 0L) {
            this.remaining -= (int)skipped;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

