/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.security;

import com.kubling.teiid.core.util.Base64;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Arrays;

public class SessionToken
implements Externalizable {
    private static final long serialVersionUID = -2853708320435636107L;
    private static final SecureRandom random = new SecureRandom();
    private String sessionID;
    private String userName;
    private byte[] secret = new byte[16];

    public SessionToken() {
    }

    public SessionToken(long id, String userName) {
        this.sessionID = Long.toString(id);
        this.userName = userName;
    }

    public SessionToken(String userName) {
        byte[] bytes = new byte[9];
        random.nextBytes(bytes);
        this.sessionID = Base64.encodeBytes((byte[])bytes);
        this.userName = userName;
        random.nextBytes(this.secret);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SessionToken)) {
            return false;
        }
        SessionToken other = (SessionToken)obj;
        return this.userName.equals(other.userName) && this.sessionID.equals(other.sessionID) && Arrays.equals(this.secret, other.secret);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getUsername() {
        return this.userName;
    }

    public String toString() {
        return "SessionToken[" + this.getUsername() + "," + this.sessionID + "]";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.secret = (byte[])in.readObject();
        this.sessionID = (String)in.readObject();
        this.userName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.secret);
        out.writeObject(this.sessionID);
        out.writeObject(this.userName);
    }
}

