/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.gss;

import com.kubling.teiid.client.security.ILogon;
import com.kubling.teiid.client.security.LogonException;
import com.kubling.teiid.client.security.LogonResult;
import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidComponentException;
import com.kubling.teiid.gss.GSSCallbackHandler;
import com.kubling.teiid.gss.GssAction;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.net.CommunicationException;
import com.kubling.teiid.net.TeiidURL;
import java.security.AccessController;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    private static final Logger logger = Logger.getLogger("org.teiid.jdbc");

    public static LogonResult authenticate(ILogon logon, Properties props) throws LogonException, TeiidComponentException, CommunicationException {
        Object result;
        Object kerberosPrincipalName;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("GSS Authentication Request");
        }
        StringBuilder errors = new StringBuilder();
        String jaasApplicationName = props.getProperty("jaasName");
        String nl = System.lineSeparator();
        if (jaasApplicationName == null) {
            jaasApplicationName = "Teiid";
        }
        if ((kerberosPrincipalName = props.getProperty("kerberosServicePrincipleName")) == null) {
            try {
                TeiidURL url = new TeiidURL(props.getProperty("serverURL"));
                kerberosPrincipalName = "TEIID/" + url.getHostInfo().getFirst().getHostName();
            }
            catch (Exception url) {
                // empty catch block
            }
            if (kerberosPrincipalName == null) {
                errors.append(JDBCPlugin.Util.getString("client_prop_missing", new Object[]{"kerberosServicePrincipleName"}));
                errors.append(nl);
            }
        }
        String krb5 = System.getProperty("java.security.krb5.conf");
        String realm = System.getProperty("java.security.krb5.realm");
        String kdc = System.getProperty("java.security.krb5.kdc");
        if (krb5 == null && realm == null && kdc == null) {
            errors.append(JDBCPlugin.Util.getString("no_gss_selection"));
            errors.append(nl);
        } else if (krb5 != null && (realm != null || kdc != null)) {
            errors.append(JDBCPlugin.Util.getString("ambigious_gss_selection"));
            errors.append(nl);
        } else if (realm != null && kdc == null || realm == null && kdc != null) {
            if (realm == null) {
                errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.krb5.realm"}));
                errors.append(nl);
            }
            if (kdc == null) {
                errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.krb5.kdc"}));
                errors.append(nl);
            }
        }
        String config = System.getProperty("java.security.auth.login.config");
        if (config == null) {
            errors.append(JDBCPlugin.Util.getString("system_prop_missing", new Object[]{"java.security.auth.login.config"}));
            errors.append(nl);
        }
        try {
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            boolean performAuthentication = true;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null) {
                Set<GSSCredential> gssCreds = sub.getPrivateCredentials(GSSCredential.class);
                if (gssCreds != null && !gssCreds.isEmpty()) {
                    gssCredential = gssCreds.iterator().next();
                    performAuthentication = false;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("GSS Authentication using delegated credential");
                    }
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No delegation credential found in the subject");
                }
            }
            if (performAuthentication) {
                if (!errors.isEmpty()) {
                    throw new LogonException(JDBCPlugin.Event.TEIID20005, errors.toString());
                }
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            GssAction action = new GssAction(logon, (String)kerberosPrincipalName, props, user, gssCredential);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new LogonException(JDBCPlugin.Event.TEIID20005, e, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20005, new Object[0]));
        }
        if (result instanceof LogonException) {
            throw (LogonException)((Object)result);
        }
        if (result instanceof TeiidComponentException) {
            throw (TeiidComponentException)((Object)result);
        }
        if (result instanceof CommunicationException) {
            throw (CommunicationException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new LogonException(JDBCPlugin.Event.TEIID20005, (Exception)result, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID20005, new Object[0]));
        }
        return (LogonResult)result;
    }
}

