/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.metadata.MetadataResult;
import com.kubling.teiid.client.metadata.ResultsMetadataConstants;
import com.kubling.teiid.core.TeiidComponentException;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.util.StringUtil;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.MetadataProvider;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.jdbc.TeiidSQLException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DeferredMetadataProvider
extends MetadataProvider {
    private final StatementImpl statement;
    private final long requestID;
    private boolean loaded;

    public DeferredMetadataProvider(String[] columnNames, String[] columnTypes, StatementImpl statement, long requestID) {
        super(DeferredMetadataProvider.loadPartialMetadata(columnNames, columnTypes));
        this.statement = statement;
        this.requestID = requestID;
    }

    static Map<Integer, String>[] loadPartialMetadata(String[] columnNames, String[] columnTypes) {
        if (columnNames == null || columnTypes == null || columnNames.length != columnTypes.length) {
            Object[] params = new Object[]{StringUtil.toString((Object[])columnNames), StringUtil.toString((Object[])columnTypes)};
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("DeferredMetadataProvider.Invalid_data", params));
        }
        Map[] columnMetadata = new Map[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnMetadata[i] = new HashMap();
            columnMetadata[i].put(ResultsMetadataConstants.ELEMENT_LABEL, columnNames[i]);
            columnMetadata[i].put(ResultsMetadataConstants.DATA_TYPE, columnTypes[i]);
        }
        return columnMetadata;
    }

    private void loadFullMetadata() throws SQLException {
        MetadataResult results;
        try {
            results = this.statement.getDQP().getMetadata(this.requestID);
        }
        catch (TeiidComponentException | TeiidProcessingException e) {
            throw TeiidSQLException.create(e);
        }
        this.metadata = results.getColumnMetadata();
    }

    @Override
    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        if (!(this.loaded || Objects.equals(metadataPropertyKey, ResultsMetadataConstants.ELEMENT_LABEL) || Objects.equals(metadataPropertyKey, ResultsMetadataConstants.DATA_TYPE))) {
            this.loadFullMetadata();
            this.loaded = true;
        }
        return super.getValue(columnIndex, metadataPropertyKey);
    }
}

