/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.ExecutionProperties;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDBCURL {
    private static final String UTF_8 = "UTF-8";
    public static final String JDBC_PROTOCOL = "jdbc:teiid:";
    static final String URL_PATTERN = "jdbc:teiid:([^@^;]+)(?:@([^;]*))?(;.*)?";
    static Pattern urlPattern = Pattern.compile("jdbc:teiid:([^@^;]+)(?:@([^;]*))?(;.*)?");
    public static final Map<String, String> EXECUTION_PROPERTIES = Collections.unmodifiableMap(JDBCURL.buildProps());
    public static final Map<String, String> KNOWN_PROPERTIES = JDBCURL.getKnownProperties();
    private String vdbName;
    private String connectionURL;
    private final Properties properties = new Properties();
    private String urlString;

    private static Map<String, String> buildProps() {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Set<String> keys = JDBCURL.extractFieldNames(ExecutionProperties.class);
        for (String key : keys) {
            result.put(key, key);
        }
        result.put("useCallingThread", "useCallingThread");
        return result;
    }

    private static Set<String> extractFieldNames(Class<?> clazz) throws AssertionError {
        Field[] fields;
        HashSet<String> result = new HashSet<String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() != String.class) continue;
            try {
                if (result.add((String)field.get(null))) continue;
                throw new AssertionError((Object)("Duplicate value for " + field.getName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static Map<String, String> getKnownProperties() {
        HashSet<String> props = new HashSet<String>(Arrays.asList("ApplicationName", "VirtualDatabaseName", "version", "VirtualDatabaseVersion", "user", "password", "waitForLoad", "autoFailover", "PassthroughAuthentication", "jaasName", "kerberosServicePrincipleName", "encryptRequests", "loginTimeout", "reportAsViews", "nullsAreSorted", "disableResultSetFetchSize"));
        props.addAll(EXECUTION_PROPERTIES.keySet());
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String string : props) {
            result.put(string, string);
        }
        return Collections.unmodifiableMap(result);
    }

    public static ConnectionType acceptsUrl(String url) {
        Matcher m = urlPattern.matcher(url);
        if (m.matches()) {
            return m.group(2) != null ? ConnectionType.Socket : ConnectionType.Embedded;
        }
        return null;
    }

    public JDBCURL(String jdbcURL) {
        this.parseURL(jdbcURL);
    }

    public JDBCURL(String vdbName, String connectionURL, Properties props) {
        if (vdbName == null || vdbName.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.vdbName = vdbName;
        this.connectionURL = connectionURL;
        if (props != null) {
            JDBCURL.normalizeProperties(props, this.properties);
        }
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)this.properties);
        return newProps;
    }

    private void parseURL(String jdbcURL) {
        String props;
        if (jdbcURL == null) {
            throw new IllegalArgumentException();
        }
        if ((jdbcURL = jdbcURL.trim()).isEmpty()) {
            throw new IllegalArgumentException();
        }
        Matcher m = urlPattern.matcher(jdbcURL);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        this.vdbName = JDBCURL.getValidValue(m.group(1));
        this.connectionURL = m.group(2);
        if (this.connectionURL != null) {
            this.connectionURL = JDBCURL.getValidValue(this.connectionURL.trim());
        }
        if ((props = m.group(3)) != null) {
            JDBCURL.parseConnectionProperties(props, this.properties);
        }
    }

    public static void parseConnectionProperties(String connectionInfo, Properties p) {
        String[] connectionParts;
        for (String connectionPart : connectionParts = connectionInfo.split(";")) {
            JDBCURL.parseConnectionProperty(connectionPart, p);
        }
    }

    static void parseConnectionProperty(String connectionProperty, Properties p) {
        if (connectionProperty.isEmpty()) {
            return;
        }
        if (connectionProperty.length() < 3) {
            throw new IllegalArgumentException();
        }
        int firstEquals = connectionProperty.indexOf(61);
        if (firstEquals < 1) {
            throw new IllegalArgumentException();
        }
        String key = connectionProperty.substring(0, firstEquals).trim();
        String value = connectionProperty.substring(firstEquals + 1).trim();
        if (value.indexOf(61) >= 0) {
            throw new IllegalArgumentException();
        }
        JDBCURL.addNormalizedProperty(JDBCURL.getValidValue(key), JDBCURL.getValidValue(value), p);
    }

    public String getJDBCURL() {
        if (this.urlString == null) {
            StringBuilder buf = new StringBuilder(JDBC_PROTOCOL).append(JDBCURL.safeEncode(this.vdbName));
            if (this.connectionURL != null) {
                buf.append('@').append(this.connectionURL);
            }
            TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(this.properties);
            for (Map.Entry<Object, Object> o : sorted.entrySet()) {
                Map.Entry<Object, Object> entry = o;
                if (!(entry.getValue() instanceof String)) continue;
                buf.append(';').append(entry.getKey()).append('=').append(JDBCURL.safeEncode((String)entry.getValue()));
            }
            this.urlString = buf.toString();
        }
        return this.urlString;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getVDBVersion() {
        if (this.properties.contains("VirtualDatabaseVersion")) {
            return this.properties.getProperty("VirtualDatabaseVersion");
        }
        return this.properties.getProperty("version");
    }

    public String getTransactionAutowrapMode() {
        return this.properties.getProperty("autoCommitTxn");
    }

    public String getPartialResultsMode() {
        return this.properties.getProperty("partialResultsMode");
    }

    public String getResultSetCacheMode() {
        return this.properties.getProperty("resultSetCacheMode");
    }

    public String getAnsiQuotedIdentifiers() {
        return this.properties.getProperty("ansiQuotedIdentifiers");
    }

    public String getFetchSize() {
        return this.properties.getProperty("fetchSize");
    }

    public String getTransparentFailover() {
        return this.properties.getProperty("autoFailover");
    }

    public String getDisableLocalTransactions() {
        return this.properties.getProperty("disableLocalTxn");
    }

    public String toString() {
        return this.getJDBCURL();
    }

    private static void normalizeProperties(Properties source, Properties target) {
        Enumeration<?> e = source.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JDBCURL.addNormalizedProperty(key, source.get(key), target);
        }
    }

    public static void addNormalizedProperty(String key, Object value, Properties target) {
        String validKey = JDBCURL.getValidKey(key);
        target.put(validKey, value);
    }

    public static String getValidKey(String key) {
        String result = KNOWN_PROPERTIES.get(key);
        if (result != null) {
            return result;
        }
        return key;
    }

    private static String getValidValue(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    private static String safeEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static Properties normalizeProperties(Properties props) {
        JDBCURL.normalizeProperties(props, props);
        return props;
    }

    public static enum ConnectionType {
        Embedded,
        Socket;

    }
}

