/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.JDBCPlugin;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;

public class MetadataProvider {
    protected Map[] metadata;

    public MetadataProvider(Map[] metadata) {
        this.metadata = Objects.requireNonNullElseGet(metadata, () -> new Map[0]);
    }

    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        if (columnIndex < 0 || columnIndex >= this.metadata.length) {
            throw new SQLException(JDBCPlugin.Util.getString("StaticMetadataProvider.Invalid_column", new Object[]{columnIndex}));
        }
        Map column = this.metadata[columnIndex];
        return column.get(metadataPropertyKey);
    }

    public int getColumnCount() {
        return this.metadata.length;
    }

    public String getStringValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        return (String)this.getValue(columnIndex, metadataPropertyKey);
    }

    public int getIntValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        return this.getIntValue(columnIndex, metadataPropertyKey, 0);
    }

    public int getIntValue(int columnIndex, Integer metadataPropertyKey, int defaultValue) throws SQLException {
        Integer val = (Integer)this.getValue(columnIndex, metadataPropertyKey);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public boolean getBooleanValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        return (Boolean)this.getValue(columnIndex, metadataPropertyKey);
    }
}

