/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.ConnectionProfile;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.net.socket.OioObjectChannelFactory;
import com.kubling.teiid.net.socket.SocketServerConnection;
import com.kubling.teiid.net.socket.SocketServerConnectionFactory;
import java.util.Properties;

final class SocketProfile
implements ConnectionProfile {
    SocketProfile() {
    }

    @Override
    public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
        SocketServerConnection serverConn;
        int loginTimeoutSeconds = 0;
        try {
            String timeout = info.getProperty("loginTimeout");
            if (timeout != null) {
                loginTimeoutSeconds = Integer.parseInt(timeout);
            }
            if (loginTimeoutSeconds > 0) {
                OioObjectChannelFactory.TIMEOUTS.set(System.currentTimeMillis() + Integer.valueOf(loginTimeoutSeconds * 1000).longValue());
            }
            serverConn = SocketServerConnectionFactory.getInstance(info).getConnection(info);
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
        finally {
            if (loginTimeoutSeconds > 0) {
                OioObjectChannelFactory.TIMEOUTS.remove();
            }
        }
        return new ConnectionImpl(serverConn, info, url);
    }
}

