/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.util.ApplicationInfo;
import com.kubling.teiid.core.util.PropertiesUtils;
import com.kubling.teiid.core.util.ReflectionHelper;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.ConnectionProfile;
import com.kubling.teiid.jdbc.JDBCPlugin;
import com.kubling.teiid.jdbc.JDBCURL;
import com.kubling.teiid.jdbc.SocketProfile;
import com.kubling.teiid.jdbc.TeiidSQLException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeiidDriver
implements Driver {
    static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static final String DRIVER_NAME = "Kubling DBVirt JDBC Driver";
    private static final TeiidDriver INSTANCE = new TeiidDriver();
    private ConnectionProfile socketProfile = new SocketProfile();
    private ConnectionProfile localProfile;

    public static TeiidDriver getInstance() {
        return INSTANCE;
    }

    @Override
    public ConnectionImpl connect(String url, Properties info) throws SQLException {
        ConnectionImpl myConnection;
        JDBCURL.ConnectionType conn = JDBCURL.acceptsUrl(url);
        if (conn == null) {
            return null;
        }
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        TeiidDriver.parseURL(url, info);
        ConnectionProfile cp = this.socketProfile;
        if (conn == JDBCURL.ConnectionType.Embedded) {
            if (this.localProfile == null) {
                try {
                    this.localProfile = (ConnectionProfile)ReflectionHelper.create((String)"org.teiid.jdbc.jboss.ModuleLocalProfile", null, (ClassLoader)this.getClass().getClassLoader());
                }
                catch (TeiidException e) {
                    throw TeiidSQLException.create(e, JDBCPlugin.Util.gs("module_load_failed", new Object[0]));
                }
            }
            cp = this.localProfile;
        }
        try {
            myConnection = cp.connect(url, info);
        }
        catch (TeiidSQLException e) {
            logger.log(Level.FINE, "Could not create connection", e);
            throw TeiidSQLException.create(e, e.getMessage());
        }
        String logMsg = JDBCPlugin.Util.getString("JDBCDriver.Connection_sucess");
        logger.fine(logMsg);
        return myConnection;
    }

    public void setLocalProfile(ConnectionProfile embeddedProfile) {
        this.localProfile = embeddedProfile;
    }

    public void setSocketProfile(ConnectionProfile socketProfile) {
        this.socketProfile = socketProfile;
    }

    @Override
    public boolean acceptsURL(String url) {
        return JDBCURL.acceptsUrl(url) != null;
    }

    @Override
    public int getMajorVersion() {
        return ApplicationInfo.getInstance().getMajorReleaseVersion();
    }

    @Override
    public int getMinorVersion() {
        return ApplicationInfo.getInstance().getMinorReleaseVersion();
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        TeiidDriver.parseURL(url, info);
        for (String property : JDBCURL.KNOWN_PROPERTIES.keySet()) {
            DriverPropertyInfo dpi = new DriverPropertyInfo(property, info.getProperty(property));
            if (property.equals("VirtualDatabaseName")) {
                dpi.required = true;
            }
            dpi.description = JDBCPlugin.Util.getString(property + "_desc");
            if (JDBCPlugin.Util.keyExists(property + "_choices")) {
                dpi.choices = JDBCPlugin.Util.getString(property + "_choices").split(",");
            }
            driverProps.add(dpi);
        }
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    protected static void parseURL(String url, Properties info) throws SQLException {
        if (url == null) {
            String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
            throw new TeiidSQLException(msg);
        }
        try {
            JDBCURL jdbcURL = new JDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            if (jdbcURL.getConnectionURL() != null) {
                info.setProperty("serverURL", jdbcURL.getConnectionURL());
            }
            Properties optionalParams = jdbcURL.getProperties();
            JDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
            if (!info.containsKey("ApplicationName")) {
                info.setProperty("ApplicationName", "JDBC");
            }
        }
        catch (IllegalArgumentException iae) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMDriver.urlFormat"));
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return logger;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", new Object[]{e.getMessage()});
            logger.log(Level.SEVERE, logMsg);
        }
    }
}

