/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.json.unflattener;

import com.github.wnameless.json.base.JsonCore;
import com.kubling.teiid.core.json.unflattener.JsonUnflattener;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;

public final class JsonUnflattenerFactory {
    private final Consumer<JsonUnflattener> configurer;
    private final Optional<JsonCore<?>> jsonCore;

    public JsonUnflattenerFactory(Consumer<JsonUnflattener> configurer) {
        this.configurer = (Consumer)Validate.notNull(configurer);
        this.jsonCore = Optional.empty();
    }

    public JsonUnflattenerFactory(Consumer<JsonUnflattener> configurer, JsonCore<?> jsonCore) {
        this.configurer = (Consumer)Validate.notNull(configurer);
        this.jsonCore = Optional.of(jsonCore);
    }

    public JsonUnflattener build(String json) {
        JsonUnflattener jf = this.jsonCore.map(core -> new JsonUnflattener((JsonCore<?>)core, json)).orElseGet(() -> new JsonUnflattener(json));
        this.configurer.accept(jf);
        return jf;
    }

    public JsonUnflattener build(Map<String, ?> flattenedMap) {
        JsonUnflattener jf = this.jsonCore.map(core -> new JsonUnflattener((JsonCore<?>)core, flattenedMap)).orElseGet(() -> new JsonUnflattener(flattenedMap));
        this.configurer.accept(jf);
        return jf;
    }

    public JsonUnflattener build(Reader jsonReader) throws IOException {
        JsonUnflattener jf = this.jsonCore.isPresent() ? new JsonUnflattener(this.jsonCore.get(), jsonReader) : new JsonUnflattener(jsonReader);
        this.configurer.accept(jf);
        return jf;
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.configurer.hashCode();
        result = 31 * result + this.jsonCore.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattenerFactory)) {
            return false;
        }
        JsonUnflattenerFactory other = (JsonUnflattenerFactory)o;
        return this.configurer.equals(other.configurer) && this.jsonCore.equals(other.jsonCore);
    }

    public String toString() {
        return "JsonUnflattenerFactory{configurer=" + String.valueOf(this.configurer) + ", jsonCore=" + String.valueOf(this.jsonCore) + "}";
    }
}

