/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.BaseLob;
import com.kubling.teiid.core.types.BlobType;
import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.types.LobSearchUtil;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import com.kubling.teiid.core.util.SqlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;

public class BlobImpl
extends BaseLob
implements Blob,
LobSearchUtil.StreamProvider {
    public BlobImpl() {
    }

    public BlobImpl(InputStreamFactory streamFactory) {
        super(streamFactory);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            Object[] params = new Object[]{pos};
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.2", params));
        }
        if (length == 0 || pos > this.length()) {
            return new byte[0];
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{length};
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.3", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        InputStream in = this.getBinaryStream();
        try {
            while (pos > 0L) {
                long skipped = in.skip(pos);
                pos -= skipped;
            }
            byte[] byArray = ObjectConverterUtil.convertToByteArray(in, length);
            return byArray;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return LobSearchUtil.position(pattern::getBinaryStream, pattern.length(), this, this.length(), start, 1);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return this.position(new SerialBlob(pattern), start);
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    public static long quickLength(Blob b) {
        if (b instanceof BlobType) {
            BlobType blob = (BlobType)b;
            long length = blob.getLength();
            if (length != -1L) {
                return length;
            }
            return BlobImpl.quickLength((Blob)blob.getReference());
        }
        if (b instanceof BlobImpl) {
            BlobImpl blob = (BlobImpl)b;
            try {
                return blob.getStreamFactory().getLength();
            }
            catch (SQLException e) {
                return -1L;
            }
        }
        try {
            return b.length();
        }
        catch (SQLException e) {
            return -1L;
        }
    }

    public String toString() {
        try {
            return new String(this.getBinaryStream().readAllBytes());
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

