/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types;

import com.kubling.teiid.core.types.BaseLob;
import com.kubling.teiid.core.types.Streamable;
import com.kubling.teiid.core.util.ReaderInputStream;
import jakarta.activation.DataSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.xml.transform.Source;

public abstract class InputStreamFactory
implements Source {
    private String systemId;
    protected long length = -1L;

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void free() throws IOException {
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Reader getCharacterStream() throws IOException {
        return null;
    }

    public StorageMode getStorageMode() {
        return StorageMode.OTHER;
    }

    public static StorageMode getStorageMode(Object lob) {
        if (lob instanceof Streamable) {
            return InputStreamFactory.getStorageMode(((Streamable)lob).getReference());
        }
        if (lob instanceof SerialClob) {
            return StorageMode.MEMORY;
        }
        if (lob instanceof SerialBlob) {
            return StorageMode.MEMORY;
        }
        if (lob instanceof BaseLob) {
            BaseLob baseLob = (BaseLob)lob;
            try {
                return baseLob.getStreamFactory().getStorageMode();
            }
            catch (SQLException e) {
                return StorageMode.FREE;
            }
        }
        return StorageMode.OTHER;
    }

    public static void setTemporary(Object lob, boolean temp) {
        if (lob instanceof Streamable) {
            InputStreamFactory.setTemporary(((Streamable)lob).getReference(), temp);
        }
        if (lob instanceof BaseLob) {
            BaseLob baseLob = (BaseLob)lob;
            try {
                baseLob.getStreamFactory().setTemporary(temp);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setTemporary(boolean temp) {
    }

    public static enum StorageMode {
        MEMORY,
        PERSISTENT,
        FREE,
        OTHER;

    }

    public static class SQLXMLInputStreamFactory
    extends InputStreamFactory
    implements DataSource {
        protected SQLXML sqlxml;

        public SQLXMLInputStreamFactory(SQLXML sqlxml) {
            this.sqlxml = sqlxml;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.sqlxml.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Reader getCharacterStream() throws IOException {
            try {
                return this.sqlxml.getCharacterStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        public String getContentType() {
            return "application/xml";
        }

        public String getName() {
            return "sqlxml";
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageMode getStorageMode() {
            return SQLXMLInputStreamFactory.getStorageMode(this.sqlxml);
        }
    }

    public static class BlobInputStreamFactory
    extends InputStreamFactory
    implements DataSource {
        private final Blob blob;

        public BlobInputStreamFactory(Blob blob) {
            this.blob = blob;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.blob.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long getLength() {
            if (this.length == -1L) {
                try {
                    this.length = this.blob.length();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return this.length;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return "blob";
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageMode getStorageMode() {
            return BlobInputStreamFactory.getStorageMode(this.blob);
        }

        @Override
        public void setTemporary(boolean temp) {
            BlobInputStreamFactory.setTemporary(this.blob, temp);
        }
    }

    public static class ClobInputStreamFactory
    extends InputStreamFactory
    implements DataSource {
        private final Clob clob;
        private Charset charset = Charset.forName("UTF-8");

        public ClobInputStreamFactory(Clob clob) {
            this.clob = clob;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return new ReaderInputStream(this.getReader(this.clob.getCharacterStream()), this.charset);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Reader getCharacterStream() throws IOException {
            try {
                return this.getReader(this.clob.getCharacterStream());
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        public String getContentType() {
            return "text/plain";
        }

        public String getName() {
            return "clob";
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageMode getStorageMode() {
            return ClobInputStreamFactory.getStorageMode(this.clob);
        }

        public Reader getReader(Reader reader) {
            return reader;
        }

        @Override
        public void setTemporary(boolean temp) {
            ClobInputStreamFactory.setTemporary(this.clob, temp);
        }
    }

    public static class FileInputStreamFactory
    extends InputStreamFactory {
        private final File f;

        public FileInputStreamFactory(File f) {
            this.f = f;
            this.setSystemId(f.toURI().toASCIIString());
        }

        @Override
        public long getLength() {
            return this.f.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.f));
        }

        @Override
        public StorageMode getStorageMode() {
            return StorageMode.PERSISTENT;
        }
    }

    public static interface StreamFactoryReference {
        public void setStreamFactory(InputStreamFactory var1);
    }
}

