/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.BinaryType;
import com.kubling.teiid.core.types.BlobType;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.util.ObjectConverterUtil;
import java.io.IOException;
import java.sql.SQLException;

public class BlobToBinaryTransform
extends Transform {
    @Override
    public Object transformDirect(Object value) throws TransformationException {
        BlobType source = (BlobType)value;
        try {
            byte[] bytes = ObjectConverterUtil.convertToByteArray(source.getBinaryStream(), DataTypeManager.MAX_VARBINARY_BYTES, true);
            return new BinaryType(bytes);
        }
        catch (IOException | SQLException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.BLOB;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.VARBINARY;
    }
}

