/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;

public class BooleanToNumberTransform
extends Transform {
    private final Object trueVal;
    private final Object falseVal;
    private final Class<?> targetType;

    public BooleanToNumberTransform(Object trueVal, Object falseVal) {
        this.trueVal = trueVal;
        this.falseVal = falseVal;
        this.targetType = trueVal.getClass();
    }

    public Class getSourceType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    public Class getTargetType() {
        return this.targetType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        return value.equals(Boolean.TRUE) ? this.trueVal : this.falseVal;
    }
}

