/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.Transform;
import com.kubling.teiid.core.types.TransformationException;

public class NumberToBooleanTransform
extends Transform {
    private final Comparable falseVal;
    private final Class<?> sourceType;

    public NumberToBooleanTransform(Comparable falseVal) {
        this.falseVal = falseVal;
        this.sourceType = falseVal.getClass();
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.falseVal.compareTo(value) == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

