/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToDoubleTransform
extends NumberToNumberTransform {
    private final boolean isNarrowing;
    private final boolean isLossy;

    public NumberToDoubleTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(-1.7976931348623157E308, Double.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.DOUBLE;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

