/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.types.basic;

import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.types.DataTypeManager;
import com.kubling.teiid.core.types.TransformationException;
import com.kubling.teiid.core.types.XMLType;
import com.kubling.teiid.core.types.basic.AnyToStringTransform;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class SQLXMLToStringTransform
extends AnyToStringTransform {
    public SQLXMLToStringTransform() {
        super(DataTypeManager.DefaultDataClasses.XML);
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        XMLType source = (XMLType)value;
        Reader reader = null;
        try {
            char[] result = new char[DataTypeManager.MAX_STRING_LENGTH];
            reader = source.getCharacterStream();
            int read = reader.read(result);
            String string = new String(result, 0, read);
            return string;
        }
        catch (IOException | SQLException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

