/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.CorePlugin;
import com.kubling.teiid.core.TeiidRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public final class ApplicationInfo
implements Serializable {
    public static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";
    public static final String APPLICATION_BUILD_NUMBER_PROPERTY = "Build";
    private static final ApplicationInfo INSTANCE = new ApplicationInfo();
    private final Properties props = new Properties();

    private ApplicationInfo() {
        InputStream is = this.getClass().getResourceAsStream("application.properties");
        try {
            try {
                this.props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10045, (Throwable)e);
        }
    }

    public String getReleaseNumber() {
        return this.props.getProperty("build.releaseNumber");
    }

    public int getMajorReleaseVersion() {
        String version = this.getReleaseNumber().substring(0, this.getReleaseNumber().indexOf(46));
        return Integer.parseInt(version);
    }

    public int getMinorReleaseVersion() {
        int majorIndex = this.getReleaseNumber().indexOf(46);
        String version = this.getReleaseNumber().substring(majorIndex + 1, this.getReleaseNumber().indexOf(46, majorIndex + 1));
        return Integer.parseInt(version);
    }

    public String getBuildNumber() {
        return this.props.getProperty("build.number");
    }

    public String getUrl() {
        return this.props.getProperty("url");
    }

    public String getCopyright() {
        return this.props.getProperty("copyright");
    }

    public String getBuildDate() {
        return this.props.getProperty("build.date");
    }

    public static ApplicationInfo getInstance() {
        return INSTANCE;
    }
}

