/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.core.util;

import com.kubling.teiid.core.CorePlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

@Deprecated
public class InputStreamReader
extends Reader {
    private final CharsetDecoder cd;
    private final ReadableByteChannel rbc;
    private final ByteBuffer bb;
    private final CharBuffer cb;
    private boolean done;
    private int bytesProcessed;

    public InputStreamReader(InputStream in, CharsetDecoder cd) {
        this(in, cd, 8192);
    }

    public InputStreamReader(InputStream in, CharsetDecoder cd, int bufferSize) {
        this.cd = cd;
        this.rbc = Channels.newChannel(in);
        this.bb = ByteBuffer.allocate(bufferSize);
        this.cb = CharBuffer.allocate((int)((double)bufferSize * (double)cd.maxCharsPerByte()));
        this.cb.limit(0);
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
        this.cd.reset();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        while (!this.done && !this.cb.hasRemaining()) {
            int read;
            int pos = this.bb.position();
            while ((read = this.rbc.read(this.bb)) == 0) {
            }
            this.bb.flip();
            this.cb.clear();
            CoderResult cr = this.cd.decode(this.bb, this.cb, read == -1);
            this.checkResult(cr);
            if (read == -1) {
                cr = this.cd.flush(this.cb);
                this.checkResult(cr);
                this.done = true;
            }
            this.bytesProcessed += this.bb.position() - pos;
            if (this.bb.position() != read + pos) {
                this.bb.compact();
            } else {
                this.bb.clear();
            }
            this.cb.flip();
        }
        if ((len = Math.min(len, this.cb.remaining())) == 0 && this.done) {
            return -1;
        }
        this.cb.get(cbuf, off, len);
        return len;
    }

    private void checkResult(CoderResult cr) throws IOException {
        if (!cr.isUnderflow() && cr.isError()) {
            if (cr.isMalformed() || cr.isUnmappable()) {
                try {
                    cr.throwException();
                }
                catch (CharacterCodingException e) {
                    throw new IOException(CorePlugin.Util.gs(CorePlugin.Event.TEIID10082, this.cd.charset().displayName(), this.bytesProcessed + this.bb.position() + 1), e);
                }
            }
            cr.throwException();
        }
    }
}

